/*
 * Decompiled with CFR 0.152.
 */
package org.constretto.internal.converter;

import java.io.File;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.constretto.ValueConverter;
import org.constretto.exception.ConstrettoConversionException;
import org.constretto.exception.ConstrettoException;
import org.constretto.internal.converter.BooleanValueConverter;
import org.constretto.internal.converter.ByteValueConverter;
import org.constretto.internal.converter.DoubleValueConverter;
import org.constretto.internal.converter.FileValueConverter;
import org.constretto.internal.converter.FloatValueConverter;
import org.constretto.internal.converter.InetAddressValueConverter;
import org.constretto.internal.converter.InputStreamValueConverter;
import org.constretto.internal.converter.IntegerValueConverter;
import org.constretto.internal.converter.LocaleValueConverter;
import org.constretto.internal.converter.LongValueConverter;
import org.constretto.internal.converter.PropertyFileValueConverter;
import org.constretto.internal.converter.ShortValueConverter;
import org.constretto.internal.converter.StringValueConverter;
import org.constretto.internal.converter.UriValueConverter;
import org.constretto.internal.converter.UrlValueConverter;
import org.constretto.model.CArray;
import org.constretto.model.CObject;
import org.constretto.model.CPrimitive;
import org.constretto.model.CValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueConverterRegistry {
    private static final Map<Class<?>, ValueConverter<?>> converters = new HashMap<Class<?>, ValueConverter<?>>(){
        {
            this.put(Boolean.class, new BooleanValueConverter());
            this.put(Boolean.TYPE, new BooleanValueConverter());
            this.put(Float.class, new FloatValueConverter());
            this.put(Float.TYPE, new FloatValueConverter());
            this.put(Double.class, new DoubleValueConverter());
            this.put(Double.TYPE, new DoubleValueConverter());
            this.put(Long.class, new LongValueConverter());
            this.put(Long.TYPE, new LongValueConverter());
            this.put(Integer.class, new IntegerValueConverter());
            this.put(Integer.TYPE, new IntegerValueConverter());
            this.put(Byte.class, new ByteValueConverter());
            this.put(Byte.TYPE, new ByteValueConverter());
            this.put(Short.class, new ShortValueConverter());
            this.put(Short.TYPE, new ShortValueConverter());
            this.put(String.class, new StringValueConverter());
            this.put(File.class, new FileValueConverter());
            this.put(Locale.class, new LocaleValueConverter());
            this.put(Properties.class, new PropertyFileValueConverter());
            this.put(InputStreamValueConverter.class, new InputStreamValueConverter());
            this.put(InetAddress.class, new InetAddressValueConverter());
            this.put(URI.class, new UriValueConverter());
            this.put(URL.class, new UrlValueConverter());
        }
    };

    public static void registerCustomConverter(Class<?> converterFor, ValueConverter<?> converter) {
        converters.put(converterFor, converter);
    }

    public static <K, V> Object convert(Class<V> valueClazz, Class<K> keyClazz, CValue value) throws ConstrettoException {
        if (value instanceof CPrimitive) {
            return ValueConverterRegistry.convertPrimitive(valueClazz, (CPrimitive)value);
        }
        if (value instanceof CArray) {
            return ValueConverterRegistry.convertList(valueClazz, (CArray)value);
        }
        if (value instanceof CObject) {
            return ValueConverterRegistry.convertMap(keyClazz, valueClazz, (CObject)value);
        }
        throw new ConstrettoException("ivalid datatype, parsing haz failed");
    }

    public static <T> List<T> convertList(Class<T> clazz, CArray list) throws ConstrettoException {
        if (!converters.containsKey(clazz)) {
            throw new ConstrettoException("No converter found for class: " + clazz.getName());
        }
        ArrayList<Object> result = new ArrayList<Object>();
        ValueConverter<?> converter = converters.get(clazz);
        for (CValue value : list.data()) {
            result.add(ValueConverterRegistry.convert(clazz, clazz, value));
        }
        return result;
    }

    public static <T> T convertPrimitive(Class<T> clazz, CPrimitive value) throws ConstrettoException {
        if (!converters.containsKey(clazz)) {
            if (!Enum.class.isAssignableFrom(clazz)) {
                throw new ConstrettoException("No converter found for class: " + clazz.getName());
            }
            return ValueConverterRegistry.convertEnum(clazz, value.value());
        }
        ValueConverter<?> converter = converters.get(clazz);
        return (T)converter.fromString(value.value());
    }

    public static <K, V> Map<K, V> convertMap(Class<K> keyClazz, Class<V> valueClazz, CObject value) throws ConstrettoException {
        if (!converters.containsKey(valueClazz)) {
            throw new ConstrettoException("No converter found for class: " + valueClazz.getName());
        }
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        ValueConverter<?> keyConverter = converters.get(keyClazz);
        for (Map.Entry valueEntry : value.data().entrySet()) {
            result.put(keyConverter.fromString((String)valueEntry.getKey()), ValueConverterRegistry.convert(valueClazz, keyClazz, (CValue)valueEntry.getValue()));
        }
        return result;
    }

    public static <T extends Enum<T>> T convertEnum(Class<T> clazz, String value) {
        try {
            return Enum.valueOf(clazz, value);
        }
        catch (IllegalArgumentException e) {
            throw new ConstrettoConversionException(value, clazz, (Throwable)e);
        }
    }
}

