/*
 * Decompiled with CFR 0.152.
 */
package org.constretto.internal.store;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.constretto.ConfigurationStore;
import org.constretto.annotation.ConfigurationSource;
import org.constretto.exception.ConstrettoException;
import org.constretto.internal.ConstrettoUtils;
import org.constretto.model.TaggedPropertySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectConfigurationStore
implements ConfigurationStore {
    private final List<Object> configurationObjects;

    public ObjectConfigurationStore() {
        this.configurationObjects = new ArrayList<Object>();
    }

    private ObjectConfigurationStore(List<Object> configurationObjects) {
        this.configurationObjects = configurationObjects;
    }

    public ObjectConfigurationStore addObject(Object configurationObject) {
        this.configurationObjects.add(configurationObject);
        return new ObjectConfigurationStore(this.configurationObjects);
    }

    @Override
    public Collection<TaggedPropertySet> parseConfiguration() {
        HashMap<String, TaggedPropertySet> propertySets = new HashMap<String, TaggedPropertySet>();
        for (Object configurationObject : this.configurationObjects) {
            TaggedPropertySet taggedPropertySet = this.createPropertySetForObject(configurationObject);
            if (propertySets.containsKey(taggedPropertySet.tag())) {
                TaggedPropertySet orginialSet = (TaggedPropertySet)propertySets.get(taggedPropertySet.tag());
                orginialSet.getProperties().putAll(taggedPropertySet.getProperties());
                propertySets.put(taggedPropertySet.tag(), orginialSet);
                continue;
            }
            propertySets.put(taggedPropertySet.tag(), taggedPropertySet);
        }
        return propertySets.values();
    }

    private TaggedPropertySet createPropertySetForObject(Object configurationObject) {
        String tag = "[default-tag]";
        String basePath = "";
        HashMap<String, String> properties = new HashMap<String, String>();
        if (configurationObject.getClass().isAnnotationPresent(ConfigurationSource.class)) {
            ConfigurationSource configurationAnnotation = configurationObject.getClass().getAnnotation(ConfigurationSource.class);
            tag = configurationAnnotation.tag();
            if (tag.equals("")) {
                tag = "[default-tag]";
            }
            basePath = configurationAnnotation.basePath();
        }
        for (PropertyDescriptor propertyDescriptor : PropertyUtils.getPropertyDescriptors((Object)configurationObject)) {
            boolean canRead = propertyDescriptor.getReadMethod() != null;
            boolean isString = propertyDescriptor.getPropertyType().isAssignableFrom(String.class);
            if (!canRead || !isString) continue;
            String path = propertyDescriptor.getName();
            try {
                String value = (String)PropertyUtils.getProperty((Object)configurationObject, (String)path);
                if (!ConstrettoUtils.isEmpty(basePath)) {
                    path = basePath + "." + path;
                }
                properties.put(path, value);
            }
            catch (Exception e) {
                throw new ConstrettoException("Could not access data in field", (Throwable)e);
            }
        }
        return new TaggedPropertySet(tag, properties, this.getClass());
    }
}

