/*
 * Decompiled with CFR 0.152.
 */
package org.constretto.model;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.constretto.model.CArray;
import org.constretto.model.CObject;
import org.constretto.model.CPrimitive;
import org.constretto.model.CValue;
import org.constretto.model.Parser;

public class GsonParser
implements Parser {
    private final GsonBuilder builder = new GsonBuilder();

    public GsonParser() {
        this.builder.registerTypeAdapter(CValue.class, (Object)new JsonDeserializer<CValue>(){

            private CArray handleArray(JsonArray jsonArray) {
                ArrayList<CValue> values = new ArrayList<CValue>();
                for (JsonElement jsonElement : jsonArray) {
                    values.add(this.handle(jsonElement));
                }
                return new CArray(values);
            }

            private CObject handleObject(JsonObject jsonObject) {
                HashMap values = new HashMap();
                for (Map.Entry entry : jsonObject.entrySet()) {
                    values.put(entry.getKey(), this.handle((JsonElement)entry.getValue()));
                }
                return new CObject(values);
            }

            private CValue handle(JsonElement json) {
                if (json.isJsonNull()) {
                    return null;
                }
                if (json.isJsonPrimitive()) {
                    return new CPrimitive(json.getAsString());
                }
                if (json.isJsonArray()) {
                    return this.handleArray(json.getAsJsonArray());
                }
                return this.handleObject(json.getAsJsonObject());
            }

            public CValue deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return this.handle(json);
            }
        });
    }

    public CValue parse(String value) {
        try {
            CValue cValue = (CValue)this.builder.create().fromJson(value, CValue.class);
            if (cValue == null) {
                return new CPrimitive(value);
            }
            return cValue;
        }
        catch (Exception e) {
            return new CPrimitive(value);
        }
    }

    public static void main(String[] args) {
        Pattern p = Pattern.compile("#\\{(.*?)}");
        Matcher m = p.matcher("#{base-url} dette er en #{variabel} sier n\u00e5 jeg, for ikke \u00e5 snakke om #{denne}");
        while (m.find()) {
            String group = m.group(1);
            System.out.println(group);
        }
    }
}

