/*
 * Decompiled with CFR 0.152.
 */
package org.constretto.model;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.constretto.exception.ConstrettoException;
import org.constretto.model.Resource;

public class UrlResource
extends Resource {
    public UrlResource(String path) {
        super(path);
    }

    public boolean exists() {
        try {
            HttpURLConnection.setFollowRedirects(true);
            HttpURLConnection con = (HttpURLConnection)new URL(this.path).openConnection();
            con.setRequestMethod("HEAD");
            int responseCode = con.getResponseCode();
            return responseCode == 200;
        }
        catch (Exception e) {
            return false;
        }
    }

    public InputStream getInputStream() {
        try {
            URL url = new URL(this.path);
            return url.openStream();
        }
        catch (MalformedURLException ex) {
            throw new ConstrettoException("Could not load URL. Path tried: [" + this.path + "]", (Throwable)ex);
        }
        catch (IOException e) {
            throw new ConstrettoException("Woot", (Throwable)e);
        }
    }
}

