/*
 * Decompiled with CFR 0.152.
 */
package org.constretto.internal.introspect;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import org.constretto.annotation.Configuration;

public class ArgumentDescription {
    private String name;
    private Annotation[] annotations;
    private Class<?> type;

    public ArgumentDescription(String name, Annotation[] annotations, Class<?> type) {
        this.name = name;
        this.annotations = annotations;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String constrettoConfigurationKeyCandidate() {
        Configuration configuration = this.findConfigurationParameter();
        if (configuration != null && !configuration.value().isEmpty()) {
            return configuration.value();
        }
        return this.getName();
    }

    private Configuration findConfigurationParameter() {
        for (Annotation annotation : this.annotations) {
            if (!(annotation instanceof Configuration)) continue;
            return (Configuration)annotation;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArgumentDescription that = (ArgumentDescription)o;
        if (!Arrays.equals(this.annotations, that.annotations)) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.annotations != null ? Arrays.hashCode(this.annotations) : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ArgumentDescription{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", annotations=").append(Arrays.toString(this.annotations));
        sb.append(", type=").append(this.type);
        sb.append('}');
        return sb.toString();
    }
}

