/*
 * Decompiled with CFR 0.152.
 */
package org.constretto.model;

import java.io.InputStream;
import org.constretto.exception.ConstrettoException;
import org.constretto.model.ClassPathResource;
import org.constretto.model.FileResource;
import org.constretto.model.UrlResource;

public abstract class Resource {
    public static final String CLASSPATH_PREFIX = "classpath:";
    public static final String FILE_PREFIX = "file:";
    final String path;

    protected Resource(String path) {
        if (path == null) {
            throw new ConstrettoException("Resources with a null value for the 'path' argument is not allowed. ");
        }
        this.path = path;
    }

    public static Resource create(String path) {
        if (path.startsWith(CLASSPATH_PREFIX)) {
            return new ClassPathResource(path);
        }
        if (path.startsWith(FILE_PREFIX)) {
            return new FileResource(path);
        }
        return new UrlResource(path);
    }

    public abstract boolean exists();

    public abstract InputStream getInputStream();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("{path='").append(this.path).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

