/*
 * Decompiled with CFR 0.152.
 */
package org.constretto.internal;

import com.thoughtworks.paranamer.BytecodeReadingParanamer;
import com.thoughtworks.paranamer.Paranamer;
import java.lang.annotation.Annotation;
import java.lang.ref.WeakReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.constretto.ConfigurationDefaultValueFactory;
import org.constretto.ConstrettoConfiguration;
import org.constretto.GenericConverter;
import org.constretto.Property;
import org.constretto.annotation.Configuration;
import org.constretto.annotation.Configure;
import org.constretto.annotation.Tags;
import org.constretto.exception.ConstrettoConversionException;
import org.constretto.exception.ConstrettoException;
import org.constretto.exception.ConstrettoExpressionException;
import org.constretto.internal.GenericCollectionTypeResolver;
import org.constretto.internal.MethodParameter;
import org.constretto.internal.converter.ValueConverterRegistry;
import org.constretto.internal.introspect.Constructors;
import org.constretto.model.CPrimitive;
import org.constretto.model.CValue;
import org.constretto.model.ConfigurationValue;

public class DefaultConstrettoConfiguration
implements ConstrettoConfiguration {
    private static final String NULL_STRING = "![![Null]!]!";
    private final Paranamer paranamer = new BytecodeReadingParanamer();
    protected final Map<String, List<ConfigurationValue>> configuration;
    private Set<WeakReference<Object>> configuredObjects = new CopyOnWriteArraySet<WeakReference<Object>>();
    private final List<String> originalTags = new ArrayList<String>();
    protected final List<String> currentTags = new ArrayList<String>();

    public DefaultConstrettoConfiguration(Map<String, List<ConfigurationValue>> configuration, List<String> originalTags) {
        this.configuration = configuration;
        this.originalTags.addAll(originalTags);
        this.currentTags.addAll(originalTags);
    }

    public DefaultConstrettoConfiguration(Map<String, List<ConfigurationValue>> configuration) {
        this.configuration = configuration;
    }

    public <K> K evaluateTo(String expression, K defaultValue) {
        K value;
        if (!this.hasValue(expression)) {
            return defaultValue;
        }
        try {
            value = (K)this.processAndConvert(defaultValue.getClass(), expression);
        }
        catch (ConstrettoConversionException e) {
            value = null;
        }
        return null != value ? value : (K)defaultValue;
    }

    public <T> T evaluateWith(GenericConverter<T> converter, String expression) {
        ConfigurationValue value = this.findElementOrThrowException(expression);
        return (T)converter.fromValue(value.value());
    }

    public CValue evaluate(String expression) throws ConstrettoExpressionException {
        return this.findElementOrThrowException(expression).value();
    }

    public <K> List<K> evaluateToList(Class<K> targetClass, String expression) {
        ConfigurationValue value = this.findElementOrThrowException(expression);
        return (List)ValueConverterRegistry.convert(targetClass, targetClass, value.value());
    }

    public <K, V> Map<K, V> evaluateToMap(Class<K> keyClass, Class<V> valueClass, String expression) {
        ConfigurationValue value = this.findElementOrThrowException(expression);
        return (Map)ValueConverterRegistry.convert(valueClass, keyClass, value.value());
    }

    public <K> K evaluateTo(Class<K> targetClass, String expression) throws ConstrettoExpressionException {
        return this.processAndConvert(targetClass, expression);
    }

    public String evaluateToString(String expression) throws ConstrettoExpressionException {
        return this.processAndConvert(String.class, expression);
    }

    public Boolean evaluateToBoolean(String expression) throws ConstrettoExpressionException {
        return this.processAndConvert(Boolean.class, expression);
    }

    public Double evaluateToDouble(String expression) throws ConstrettoExpressionException {
        return this.processAndConvert(Double.class, expression);
    }

    public Long evaluateToLong(String expression) throws ConstrettoExpressionException {
        return this.processAndConvert(Long.class, expression);
    }

    public Float evaluateToFloat(String expression) throws ConstrettoExpressionException {
        return this.processAndConvert(Float.class, expression);
    }

    public Integer evaluateToInt(String expression) throws ConstrettoExpressionException {
        return this.processAndConvert(Integer.class, expression);
    }

    public Short evaluateToShort(String expression) throws ConstrettoExpressionException {
        return this.processAndConvert(Short.class, expression);
    }

    public Byte evaluateToByte(String expression) throws ConstrettoExpressionException {
        return this.processAndConvert(Byte.class, expression);
    }

    public <T> T as(Class<T> configurationClass) throws ConstrettoException {
        T objectToConfigure;
        try {
            objectToConfigure = this.createInstance(configurationClass);
        }
        catch (ConstrettoException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConstrettoException("Could not instansiate class of type: " + configurationClass.getName() + " when trying to inject it with configuration, It may be missing a default or @Configure annotated constructor", (Throwable)e);
        }
        this.injectConfiguration(objectToConfigure);
        return objectToConfigure;
    }

    public <T> T on(T objectToConfigure) throws ConstrettoException {
        this.injectConfiguration(objectToConfigure);
        return objectToConfigure;
    }

    public boolean hasValue(String expression) {
        return this.findElementOrNull(expression) != null;
    }

    public void appendTag(String ... newtags) {
        this.currentTags.addAll(Arrays.asList(newtags));
        this.reconfigure();
    }

    public void prependTag(String ... newtags) {
        this.currentTags.addAll(0, Arrays.asList(newtags));
        this.reconfigure();
    }

    public void resetTags(boolean reconfigure) {
        this.currentTags.clear();
        this.currentTags.addAll(this.originalTags);
        if (reconfigure) {
            this.reconfigure();
        }
    }

    public void clearTags(boolean reconfigure) {
        this.currentTags.clear();
        this.originalTags.clear();
        if (reconfigure) {
            this.reconfigure();
        }
    }

    public void removeTag(String ... newTags) {
        for (String newTag : newTags) {
            this.currentTags.remove(newTag);
        }
        this.reconfigure();
    }

    public List<String> getCurrentTags() {
        return this.currentTags;
    }

    public Iterator<Property> iterator() {
        ArrayList<Property> properties = new ArrayList<Property>();
        Map<String, String> map = this.asMap();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            properties.add(new Property(entry.getKey(), entry.getValue()));
        }
        return properties.iterator();
    }

    public void reconfigure() {
        WeakReference[] references;
        for (WeakReference reference : references = this.configuredObjects.toArray(new WeakReference[this.configuredObjects.size()])) {
            if (reference == null || reference.get() == null) continue;
            this.on(reference.get());
        }
    }

    private <T> T createInstance(Class<T> configurationClass) throws InstantiationException, IllegalAccessException {
        if (configurationClass.isInterface()) {
            throw new ConstrettoException("Can not instantiate interfaces. You need to create an concrete implementing class first");
        }
        if (configurationClass.isAnonymousClass()) {
            throw new ConstrettoException("Can not instantiate anonymous classes using as(Class<T>. To inject configuration in to inner or anonymous classes, instantiate it first and call the on(T configuredObjecT) method");
        }
        Constructor<T>[] annotatedConstructors = this.findAnnotatedConstructorsOnClass(configurationClass);
        if (configurationClass.isMemberClass() && annotatedConstructors != null) {
            throw new ConstrettoException("Can not instantiate inner classes using a @Configure annotated constructor. To inject configuration, construct the instance yourself use the \"on(T configuredObject)\" method");
        }
        if (annotatedConstructors == null) {
            return configurationClass.newInstance();
        }
        if (annotatedConstructors.length > 1) {
            throw new ConstrettoException("More than one @Configure annotated constructor defined for class \"" + configurationClass.getName() + "\". It can only be one");
        }
        Constructor<T> constructor = annotatedConstructors[0];
        Object[] resolvedParameters = this.resolveParameters(constructor);
        try {
            constructor.setAccessible(true);
            return constructor.newInstance(resolvedParameters);
        }
        catch (InvocationTargetException e) {
            throw new ConstrettoException("Could not instantiate class with @Configure annotated constructor");
        }
    }

    private <T> Constructor<T>[] findAnnotatedConstructorsOnClass(Class<T> configurationClass) {
        return Constructors.findConstructorsWithConfigureAnnotation(configurationClass);
    }

    private Map<String, String> asMap() {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Map.Entry<String, List<ConfigurationValue>> entry : this.configuration.entrySet()) {
            ConfigurationValue value = this.findElementOrNull(entry.getKey());
            if (value == null) continue;
            properties.put(entry.getKey(), value.value().toString());
        }
        return properties;
    }

    protected ConfigurationValue findElementOrThrowException(String expression) {
        if (!this.configuration.containsKey(expression)) {
            throw new ConstrettoExpressionException(expression, this.currentTags);
        }
        List<ConfigurationValue> values = this.configuration.get(expression);
        ConfigurationValue resolvedNode = this.resolveMatch(values);
        if (resolvedNode == null) {
            throw new ConstrettoExpressionException(expression, this.currentTags);
        }
        if (resolvedNode.value().containsVariables()) {
            for (String key : resolvedNode.value().referencedKeys()) {
                resolvedNode.value().replace(key, this.evaluateToString(key));
            }
        }
        return resolvedNode;
    }

    protected ConfigurationValue findElementOrNull(String expression) {
        if (!this.configuration.containsKey(expression)) {
            return null;
        }
        List<ConfigurationValue> values = this.configuration.get(expression);
        ConfigurationValue resolvedNode = this.resolveMatch(values);
        if (resolvedNode == null) {
            return null;
        }
        if (resolvedNode.value().containsVariables()) {
            for (String key : resolvedNode.value().referencedKeys()) {
                resolvedNode.value().replace(key, this.evaluateToString(key));
            }
        }
        return resolvedNode;
    }

    private <T> T processAndConvert(Class<T> clazz, String expression) throws ConstrettoException {
        ConfigurationValue value = this.findElementOrThrowException(expression);
        return (T)ValueConverterRegistry.convert(clazz, clazz, value.value());
    }

    private ConfigurationValue resolveMatch(List<ConfigurationValue> values) {
        ConfigurationValue bestMatch = null;
        for (ConfigurationValue configurationNode : values) {
            if ("[default-tag]".equals(configurationNode.tag())) {
                if (bestMatch != null && !bestMatch.tag().equals("[default-tag]")) continue;
                bestMatch = configurationNode;
                continue;
            }
            if (this.currentTags.contains(configurationNode.tag())) {
                int previousFoundPriority;
                if (bestMatch == null) {
                    bestMatch = configurationNode;
                    continue;
                }
                int n = previousFoundPriority = "[default-tag]".equals(bestMatch.tag()) ? Integer.MAX_VALUE : this.currentTags.indexOf(bestMatch.tag());
                if (this.currentTags.indexOf(configurationNode.tag()) > previousFoundPriority) continue;
                bestMatch = configurationNode;
                continue;
            }
            if (!"[all-tag]".equals(configurationNode.tag())) continue;
            bestMatch = configurationNode;
        }
        return bestMatch;
    }

    private <T> void injectConfiguration(T objectToConfigure) {
        this.injectFields(objectToConfigure);
        this.injectMethods(objectToConfigure);
        boolean found = false;
        for (WeakReference<Object> configuredObject : this.configuredObjects) {
            if (configuredObject.get() != objectToConfigure) continue;
            found = true;
            break;
        }
        if (!found) {
            this.configuredObjects.add(new WeakReference<T>(objectToConfigure));
        }
    }

    private Object[] resolveParameters(AccessibleObject accessibleObject) throws IllegalAccessException, InstantiationException {
        Class<?>[] parameterTargetTypes;
        String[] parameterNames;
        Annotation[][] methodAnnotations;
        if (accessibleObject instanceof Method) {
            Method method = (Method)accessibleObject;
            methodAnnotations = method.getParameterAnnotations();
            parameterNames = this.paranamer.lookupParameterNames((AccessibleObject)method);
            parameterTargetTypes = method.getParameterTypes();
        } else if (accessibleObject instanceof Constructor) {
            Constructor constructor = (Constructor)accessibleObject;
            methodAnnotations = constructor.getParameterAnnotations();
            parameterNames = this.paranamer.lookupParameterNames((AccessibleObject)constructor);
            parameterTargetTypes = constructor.getParameterTypes();
        } else {
            throw new ConstrettoException("Could not resolve parameter names ");
        }
        Object[] resolvedArguments = new Object[methodAnnotations.length];
        int i = 0;
        for (Annotation[] parameterAnnotations : methodAnnotations) {
            Object defaultValue = null;
            boolean required = true;
            String expression = "";
            Class<Object> parameterTargetClass = parameterTargetTypes[i];
            if (parameterAnnotations.length != 0) {
                for (Annotation parameterAnnotation : parameterAnnotations) {
                    if (parameterAnnotation.annotationType() != Configuration.class) continue;
                    Configuration configurationAnnotation = (Configuration)parameterAnnotation;
                    expression = configurationAnnotation.value();
                    required = configurationAnnotation.required();
                    if (!this.hasAnnotationDefaults(configurationAnnotation)) continue;
                    if (configurationAnnotation.defaultValueFactory().equals(Configuration.EmptyValueFactory.class)) {
                        defaultValue = ValueConverterRegistry.convert(parameterTargetClass, parameterTargetClass, (CValue)new CPrimitive(configurationAnnotation.defaultValue()));
                        continue;
                    }
                    ConfigurationDefaultValueFactory valueFactory = (ConfigurationDefaultValueFactory)configurationAnnotation.defaultValueFactory().newInstance();
                    defaultValue = valueFactory.getDefaultValue();
                }
            }
            if (expression.equals("")) {
                if (parameterNames == null) {
                    throw new ConstrettoException("Could not resolve the expression of the property to look up. The cause of this could be that the class is compiled without debug enabled. when a class is compiled without debug, the @Configuration with a value attribute is required to correctly resolve the property expression.");
                }
                expression = parameterNames[i];
            }
            if (this.hasValue(expression)) {
                if (parameterTargetClass.isAssignableFrom(List.class)) {
                    Class<?> collectionParameterType = GenericCollectionTypeResolver.getCollectionParameterType(this.createMethodParameter(accessibleObject, i));
                    resolvedArguments[i] = this.evaluateToList(collectionParameterType, expression);
                } else if (parameterTargetClass.isAssignableFrom(Map.class)) {
                    Class<?> mapKeyType = GenericCollectionTypeResolver.getMapKeyParameterType(this.createMethodParameter(accessibleObject, i));
                    Class<?> mapValueType = GenericCollectionTypeResolver.getMapValueParameterType(this.createMethodParameter(accessibleObject, i));
                    resolvedArguments[i] = this.evaluateToMap(mapKeyType, mapValueType, expression);
                } else {
                    resolvedArguments[i] = this.processAndConvert(parameterTargetClass, expression);
                }
            } else if (defaultValue != null || !required) {
                resolvedArguments[i] = defaultValue;
            } else {
                if (accessibleObject instanceof Constructor) {
                    Constructor constructor = (Constructor)accessibleObject;
                    throw new ConstrettoException("Missing value or default value for expression [" + expression + "], in annotated constructor in class [" + constructor.getClass().getName() + "], with tags " + this.currentTags + ".");
                }
                Method method = (Method)accessibleObject;
                throw new ConstrettoException("Missing value or default value for expression [" + expression + "], in method [" + method.getName() + "], in class [" + method.getClass().getName() + "], with tags " + this.currentTags + ".");
            }
            ++i;
        }
        return resolvedArguments;
    }

    private <T> void injectMethods(T objectToConfigure) {
        Method[] methods;
        for (Method method : methods = objectToConfigure.getClass().getMethods()) {
            try {
                if (!method.isAnnotationPresent(Configure.class)) continue;
                Object[] resolvedArguments = this.resolveParameters(method);
                method.setAccessible(true);
                method.invoke(objectToConfigure, resolvedArguments);
            }
            catch (IllegalAccessException e) {
                throw new ConstrettoException("Cold not invoke method [" + method.getName() + "] annotated with @Configured,", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new ConstrettoException("Cold not invoke method [" + method.getName() + "] annotated with @Configured,", (Throwable)e);
            }
            catch (InstantiationException e) {
                throw new ConstrettoException("Cold not invoke method [" + method.getName() + "] annotated with @Configured,", (Throwable)e);
            }
        }
    }

    private <T extends AccessibleObject> MethodParameter createMethodParameter(T accessibleObject, int parameterIndex) {
        if (accessibleObject instanceof Constructor) {
            return new MethodParameter((Constructor)accessibleObject, parameterIndex);
        }
        return new MethodParameter((Method)accessibleObject, parameterIndex);
    }

    private <T> void injectFields(T objectToConfigure) {
        Class<?> objectToConfigureClass = objectToConfigure.getClass();
        do {
            Field[] fields;
            for (Field field : fields = objectToConfigureClass.getDeclaredFields()) {
                try {
                    if (field.isAnnotationPresent(Configuration.class)) {
                        Configuration configurationAnnotation = field.getAnnotation(Configuration.class);
                        String expression = "".equals(configurationAnnotation.value()) ? field.getName() : configurationAnnotation.value();
                        field.setAccessible(true);
                        Class<Object> fieldType = field.getType();
                        if (this.hasValue(expression)) {
                            ConfigurationValue node = this.findElementOrThrowException(expression);
                            if (fieldType.isAssignableFrom(List.class)) {
                                field.set(objectToConfigure, this.evaluateToList(GenericCollectionTypeResolver.getCollectionFieldType(field), expression));
                                continue;
                            }
                            if (fieldType.isAssignableFrom(Map.class)) {
                                field.set(objectToConfigure, this.evaluateToMap(GenericCollectionTypeResolver.getMapKeyFieldType(field), GenericCollectionTypeResolver.getMapValueFieldType(field), expression));
                                continue;
                            }
                            field.set(objectToConfigure, this.processAndConvert(fieldType, expression));
                            continue;
                        }
                        if (this.hasAnnotationDefaults(configurationAnnotation)) {
                            if (configurationAnnotation.defaultValueFactory().equals(Configuration.EmptyValueFactory.class)) {
                                field.set(objectToConfigure, ValueConverterRegistry.convert(fieldType, fieldType, (CValue)new CPrimitive(configurationAnnotation.defaultValue())));
                                continue;
                            }
                            ConfigurationDefaultValueFactory valueFactory = (ConfigurationDefaultValueFactory)configurationAnnotation.defaultValueFactory().newInstance();
                            field.set(objectToConfigure, valueFactory.getDefaultValue());
                            continue;
                        }
                        if (!configurationAnnotation.required()) continue;
                        throw new ConstrettoException("Missing value or default value for expression [" + expression + "] for field [" + field.getName() + "], in class [" + objectToConfigure.getClass().getName() + "] with tags " + this.currentTags + ".");
                    }
                    if (!field.isAnnotationPresent(Tags.class)) continue;
                    field.setAccessible(true);
                    field.set(objectToConfigure, this.currentTags);
                }
                catch (IllegalAccessException e) {
                    throw new ConstrettoException("Cold not inject configuration into field [" + field.getName() + "] annotated with @Configuration, in class [" + objectToConfigure.getClass().getName() + "] with tags " + this.currentTags, (Throwable)e);
                }
                catch (InstantiationException e) {
                    throw new ConstrettoException("Cold not inject configuration into field [" + field.getName() + "] annotated with @Configuration, in class [" + objectToConfigure.getClass().getName() + "] with tags " + this.currentTags, (Throwable)e);
                }
            }
        } while ((objectToConfigureClass = objectToConfigureClass.getSuperclass()) != null);
    }

    private boolean hasAnnotationDefaults(Configuration configurationAnnotation) {
        return !"N/A".equals(configurationAnnotation.defaultValue()) || !configurationAnnotation.defaultValueFactory().equals(Configuration.EmptyValueFactory.class);
    }
}

