/*
 * Decompiled with CFR 0.152.
 */
package org.constretto.internal.store;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.constretto.ConfigurationStore;
import org.constretto.exception.ConstrettoException;
import org.constretto.model.Resource;
import org.constretto.model.TaggedPropertySet;
import org.ini4j.IniPreferences;

public class IniFileConfigurationStore
implements ConfigurationStore {
    private static final String DEFAULT_TAG = "default";
    private List<Resource> resources = new ArrayList<Resource>();

    public IniFileConfigurationStore() {
    }

    private IniFileConfigurationStore(List<Resource> resources) {
        this.resources = resources;
    }

    public IniFileConfigurationStore addResource(Resource resource) {
        this.resources.add(resource);
        return new IniFileConfigurationStore(this.resources);
    }

    public List<TaggedPropertySet> parseConfiguration() {
        ArrayList<TaggedPropertySet> taggedPropertySets = new ArrayList<TaggedPropertySet>();
        for (Resource r : this.resources) {
            if (!r.exists()) continue;
            Preferences prefs = this.load(r);
            List<String> tags = this.getChildren(prefs);
            for (String tag : tags) {
                Preferences node = prefs.node(tag);
                List<String> keysPerNode = this.getKeys(node);
                HashMap<String, String> properties = new HashMap<String, String>();
                for (String key : keysPerNode) {
                    String value = node.get(key, null);
                    properties.put(key, value);
                }
                if (tag.equals(DEFAULT_TAG)) {
                    tag = "[default-tag]";
                }
                TaggedPropertySet taggedPropertySet = new TaggedPropertySet(tag, properties, this.getClass());
                taggedPropertySets.add(taggedPropertySet);
            }
        }
        return taggedPropertySets;
    }

    private List<String> getKeys(Preferences p) {
        try {
            return Arrays.asList(p.keys());
        }
        catch (BackingStoreException e) {
            throw new ConstrettoException((Throwable)e);
        }
    }

    private List<String> getChildren(Preferences p) {
        try {
            return Arrays.asList(p.childrenNames());
        }
        catch (BackingStoreException e) {
            throw new ConstrettoException((Throwable)e);
        }
    }

    private Preferences load(Resource resource) {
        try {
            return new IniPreferences(resource.getInputStream());
        }
        catch (Exception e) {
            throw new ConstrettoException((Throwable)e);
        }
    }
}

