/*
 * Decompiled with CFR 0.152.
 */
package org.constretto.internal.store.ldap;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.constretto.ConfigurationStore;
import org.constretto.exception.ConstrettoException;
import org.constretto.model.TaggedPropertySet;

public class LdapConfigurationStore
implements ConfigurationStore {
    private Map<String, Attributes> keyAttributesMap = Collections.emptyMap();
    private List<String> tags = Collections.emptyList();
    private final Gson gsonSerializer = new Gson();

    public LdapConfigurationStore() {
        this.tags = Arrays.asList("[default-tag]");
    }

    private LdapConfigurationStore(List<String> tags) {
        this.tags = tags;
    }

    public LdapConfigurationStore(LdapConfigurationStore oldStore, String key, Attributes attributes, String ... tags) {
        this(tags == null || tags.length == 0 ? Arrays.asList("[default-tag]") : Arrays.asList(tags));
        this.keyAttributesMap = new HashMap<String, Attributes>(oldStore.keyAttributesMap.size() + 1);
        this.keyAttributesMap.putAll(oldStore.keyAttributesMap);
        this.keyAttributesMap.put(key, attributes);
    }

    public LdapConfigurationStore(LdapConfigurationStore oldStore, Attributes attributes, String ... tags) {
        this(oldStore, null, attributes, tags);
    }

    @Override
    public Collection<TaggedPropertySet> parseConfiguration() {
        HashMap<String, String> properties = new HashMap<String, String>(this.keyAttributesMap.size());
        for (String key : this.keyAttributesMap.keySet()) {
            properties.putAll(this.convertAttributesToProperties(key, this.keyAttributesMap.get(key)));
        }
        return this.createTaggedPropertySetsFromProperties(properties);
    }

    private List<TaggedPropertySet> createTaggedPropertySetsFromProperties(Map<String, String> properties) {
        ArrayList<TaggedPropertySet> taggedPropertySets = new ArrayList<TaggedPropertySet>(this.tags.size());
        for (String tag : this.tags) {
            taggedPropertySets.add(new TaggedPropertySet(tag, properties, this.getClass()));
        }
        return taggedPropertySets;
    }

    private Map<String, String> convertAttributesToProperties(String key, Attributes attributes) {
        HashMap<String, String> properties = new HashMap<String, String>(this.keyAttributesMap.size());
        try {
            NamingEnumeration<? extends Attribute> attributesAll = attributes.getAll();
            while (attributesAll.hasMore()) {
                Attribute attribute = attributesAll.next();
                if (attribute.getID().contains("password")) continue;
                properties.put(this.mergeKeyAndId(key, attribute.getID()), this.convertAttribute(attribute));
            }
        }
        catch (NamingException e) {
            throw new ConstrettoException("Could not read attributes from LDAP");
        }
        return properties;
    }

    private String convertAttribute(Attribute attribute) throws NamingException {
        int subElementsCount = attribute.size();
        if (subElementsCount == 1) {
            return attribute.get().toString();
        }
        ArrayList<String> multiValue = new ArrayList<String>(subElementsCount);
        for (int i = 0; i < subElementsCount; ++i) {
            multiValue.add(attribute.get(i).toString());
        }
        return this.gsonSerializer.toJson(multiValue);
    }

    private String mergeKeyAndId(String key, String id) {
        return key == null ? id : key + "." + id;
    }
}

