/*
 * Decompiled with CFR 0.152.
 */
package org.constretto.internal.store;

import java.util.Properties;
import org.constretto.internal.store.PropertiesStore;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.encryption.pbe.PBEStringEncryptor;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.properties.EncryptableProperties;

public class EncryptedPropertiesStore
extends PropertiesStore {
    private final PBEStringEncryptor encryptor = new StandardPBEStringEncryptor();

    public EncryptedPropertiesStore(String passwordProperty) {
        this.encryptor.setPassword(this.getFromSystemPropertyOrSystemEnv(passwordProperty));
    }

    private String getFromSystemPropertyOrSystemEnv(String key) {
        String password = System.getProperty(key);
        if (password == null) {
            password = System.getenv(key);
        }
        return password;
    }

    @Override
    protected Properties parseProperties(Properties props) {
        return new EncryptableProperties(props, (StringEncryptor)this.encryptor);
    }
}

