/*
 * Decompiled with CFR 0.152.
 */
package org.constretto.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.constretto.exception.ConstrettoException;
import org.constretto.model.Resource;

public class FileResource
extends Resource {
    public FileResource(String path) {
        super(path);
    }

    @Override
    public boolean exists() {
        return new File(this.extractFileNameFromFileResource(this.path)).exists();
    }

    @Override
    public InputStream getInputStream() {
        String fileName = this.extractFileNameFromFileResource(this.path);
        try {
            return new FileInputStream(new File(fileName));
        }
        catch (FileNotFoundException e) {
            throw new ConstrettoException("Could not read file from path: " + this.path);
        }
    }

    private String extractFileNameFromFileResource(String path) {
        String fileName = path.startsWith("file:") ? path.substring("file:".length(), path.length()) : path;
        return fileName;
    }
}

