/*
 * Decompiled with CFR 0.152.
 */
package org.constretto.resolver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.constretto.resolver.ConfigurationContextResolver;

public class PredefinedConfigurationContextResolver
implements ConfigurationContextResolver {
    private List<String> tags;

    private PredefinedConfigurationContextResolver(List<String> tags) {
        this.tags = PredefinedConfigurationContextResolver.cloneTagList(tags);
    }

    private static List<String> cloneTagList(List<String> tags) {
        if (tags == null) {
            return Collections.emptyList();
        }
        ArrayList<String> newList = new ArrayList<String>(tags.size());
        for (String tag : tags) {
            newList.add(tag);
        }
        return newList;
    }

    public List<String> getTags() {
        return PredefinedConfigurationContextResolver.cloneTagList(this.tags);
    }

    public static PredefinedConfigurationContextResolver empty() {
        return new PredefinedConfigurationContextResolver(Collections.emptyList());
    }

    public static PredefinedConfigurationContextResolver usingTags(String ... tags) {
        if (tags == null) {
            return PredefinedConfigurationContextResolver.empty();
        }
        return PredefinedConfigurationContextResolver.usingTagsList(Arrays.asList(tags));
    }

    public static PredefinedConfigurationContextResolver usingTagsList(List<String> tags) {
        return new PredefinedConfigurationContextResolver(tags);
    }
}

