/*
 * Decompiled with CFR 0.152.
 */
package org.constretto;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.naming.directory.DirContext;
import org.constretto.ConfigurationStore;
import org.constretto.ConstrettoConfiguration;
import org.constretto.internal.DefaultConstrettoConfiguration;
import org.constretto.internal.resolver.DefaultConfigurationContextResolver;
import org.constretto.internal.store.EncryptedPropertiesStore;
import org.constretto.internal.store.IniFileConfigurationStore;
import org.constretto.internal.store.JsonStore;
import org.constretto.internal.store.NestedConfigurationStore;
import org.constretto.internal.store.ObjectConfigurationStore;
import org.constretto.internal.store.PropertiesStore;
import org.constretto.internal.store.SystemPropertiesStore;
import org.constretto.internal.store.YamlStore;
import org.constretto.internal.store.ldap.LdapConfigurationStoreBuilder;
import org.constretto.model.ConfigurationValue;
import org.constretto.model.GsonParser;
import org.constretto.model.Parser;
import org.constretto.model.Resource;
import org.constretto.model.TaggedPropertySet;
import org.constretto.resolver.ConfigurationContextResolver;

public class ConstrettoBuilder {
    public static final String OVERRIDES = "CONSTRETTO_OVERRIDES";
    private final List<ConfigurationStore> configurationStores;
    private final List<String> tags;
    private final boolean enableSystemProps;
    private final Parser parser = new GsonParser();

    @Deprecated
    public ConstrettoBuilder() {
        this(new DefaultConfigurationContextResolver(), true);
    }

    @Deprecated
    public ConstrettoBuilder(boolean enableSystemProps) {
        this(new DefaultConfigurationContextResolver(), enableSystemProps);
    }

    public ConstrettoBuilder(ConfigurationContextResolver configurationContextResolver, boolean enableSystemProps) {
        this.configurationStores = new ArrayList<ConfigurationStore>();
        this.tags = new ArrayList<String>();
        this.enableSystemProps = enableSystemProps;
        for (String tag : configurationContextResolver.getTags()) {
            this.addCurrentTag(tag);
        }
        if (enableSystemProps) {
            this.configurationStores.add(new SystemPropertiesStore());
        }
    }

    private ConstrettoBuilder(List<ConfigurationStore> configurationStores, List<String> tags, boolean enableSystemProps) {
        this.enableSystemProps = enableSystemProps;
        this.configurationStores = configurationStores;
        this.tags = tags;
    }

    public static ConstrettoBuilder withSystemProperties(ConfigurationContextResolver contextResolver) {
        return new ConstrettoBuilder(contextResolver, true);
    }

    public static ConstrettoBuilder withSystemProperties() {
        return ConstrettoBuilder.withSystemProperties(new DefaultConfigurationContextResolver());
    }

    public static ConstrettoBuilder empty() {
        return ConstrettoBuilder.empty(new DefaultConfigurationContextResolver());
    }

    public static ConstrettoBuilder empty(ConfigurationContextResolver configurationContextResolver) {
        return new ConstrettoBuilder(configurationContextResolver, false);
    }

    public static ConstrettoBuilder fromExistingConfiguration(ConstrettoConfiguration constrettoConfiguration, ConfigurationContextResolver configurationContextResolver) {
        Objects.requireNonNull(constrettoConfiguration, "The \"constrettoConfiguration\" argument can not be null");
        Objects.requireNonNull(configurationContextResolver, "The \"configurationContextResolver\" argument can not be null");
        return new ConstrettoBuilder(configurationContextResolver, false).addExistingConfiguration(constrettoConfiguration);
    }

    public static ConstrettoBuilder fromExistingConfiguration(ConstrettoConfiguration constrettoConfiguration) {
        return ConstrettoBuilder.fromExistingConfiguration(constrettoConfiguration, new DefaultConfigurationContextResolver());
    }

    public ConstrettoConfiguration getConfiguration() {
        this.addOverrideStores();
        HashMap<String, List<ConfigurationValue>> configuration = new HashMap<String, List<ConfigurationValue>>();
        Collection<TaggedPropertySet> taggedPropertySets = this.loadPropertySets();
        for (TaggedPropertySet taggedPropertySet : taggedPropertySets) {
            Map<String, String> properties = taggedPropertySet.getProperties();
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                List<ConfigurationValue> values;
                if (configuration.containsKey(entry.getKey())) {
                    values = (List)configuration.get(entry.getKey());
                    if (values == null) {
                        values = new ArrayList();
                    }
                    values.add(new ConfigurationValue(this.parser.parse(entry.getValue()), taggedPropertySet.tag()));
                    configuration.put(entry.getKey(), values);
                    continue;
                }
                values = new ArrayList<ConfigurationValue>();
                values.add(new ConfigurationValue(this.parser.parse(entry.getValue()), taggedPropertySet.tag()));
                configuration.put(entry.getKey(), values);
            }
        }
        return new DefaultConstrettoConfiguration(configuration, this.tags);
    }

    private void addOverrideStores() {
        String overrideValue = System.getProperty(OVERRIDES);
        if (overrideValue != null) {
            String[] locations;
            for (String location : locations = overrideValue.split(",")) {
                this.addOverrideStore(location);
            }
        }
    }

    private void addOverrideStore(String location) {
        if (location.endsWith(".properties")) {
            PropertiesStoreBuilder propertiesBuilder = this.createPropertiesStore();
            propertiesBuilder.addResource(Resource.create(location));
            propertiesBuilder.done();
        } else if (location.endsWith(".ini")) {
            IniFileConfigurationStoreBuilder iniBuilder = this.createIniFileConfigurationStore();
            iniBuilder.addResource(Resource.create(location));
            iniBuilder.done();
        }
    }

    public ConstrettoBuilder addCurrentTag(String tag) {
        this.tags.add(tag);
        return new ConstrettoBuilder(this.configurationStores, this.tags, this.enableSystemProps);
    }

    public ConstrettoBuilder addConfigurationStore(ConfigurationStore configurationStore) {
        this.configurationStores.add(configurationStore);
        return new ConstrettoBuilder(this.configurationStores, this.tags, this.enableSystemProps);
    }

    public ConstrettoBuilder addExistingConfiguration(ConstrettoConfiguration constrettoConfiguration) {
        this.addConfigurationStore(new NestedConfigurationStore(constrettoConfiguration));
        return this;
    }

    public PropertiesStoreBuilder createPropertiesStore() {
        return new PropertiesStoreBuilder();
    }

    public EncryptedPropertiesStoreBuilder createEncryptedPropertiesStore(String passwordProperty) {
        return new EncryptedPropertiesStoreBuilder(passwordProperty);
    }

    public IniFileConfigurationStoreBuilder createIniFileConfigurationStore() {
        return new IniFileConfigurationStoreBuilder();
    }

    public JsonStoreBuilder createJsonConfigurationStore() {
        return new JsonStoreBuilder();
    }

    public ConstrettoBuilder createSystemPropertiesStore() {
        this.configurationStores.add(new SystemPropertiesStore());
        return new ConstrettoBuilder(this.configurationStores, this.tags, this.enableSystemProps);
    }

    public ObjectConfigurationStoreBuilder createObjectConfigurationStore() {
        return new ObjectConfigurationStoreBuilder();
    }

    public WrappedLdapConfigurationStoreBuilder createLdapConfigurationStore(DirContext dirContext) {
        return new WrappedLdapConfigurationStoreBuilder(LdapConfigurationStoreBuilder.usingDirContext(dirContext));
    }

    private Collection<TaggedPropertySet> loadPropertySets() {
        ArrayList<TaggedPropertySet> taggedPropertySets = new ArrayList<TaggedPropertySet>();
        for (ConfigurationStore configurationStore : this.configurationStores) {
            taggedPropertySets.addAll(configurationStore.parseConfiguration());
        }
        return taggedPropertySets;
    }

    public YamlStoreBuilder createYamlConfigurationStore() {
        return new YamlStoreBuilder();
    }

    public class WrappedLdapConfigurationStoreBuilder
    extends ContributingStoreBuilder {
        private LdapConfigurationStoreBuilder ldapConfigurationStoreBuilder;

        public WrappedLdapConfigurationStoreBuilder(LdapConfigurationStoreBuilder ldapConfigurationStoreBuilder) {
            this.ldapConfigurationStoreBuilder = ldapConfigurationStoreBuilder;
        }

        public WrappedLdapConfigurationStoreBuilder addDsnWithKey(String key, String distinguishedName, String ... tags) {
            this.ldapConfigurationStoreBuilder.addDsnWithKey(key, distinguishedName, tags);
            return this;
        }

        public WrappedLdapConfigurationStoreBuilder addDsn(String distinguishedName, String ... tags) {
            this.ldapConfigurationStoreBuilder.addDsn(distinguishedName, tags);
            return this;
        }

        public WrappedLdapConfigurationStoreBuilder addUsingSearch(String searchBase, String filter, String keyAttribute, String ... tags) {
            this.ldapConfigurationStoreBuilder.addUsingSearch(searchBase, filter, keyAttribute, tags);
            return this;
        }

        @Override
        ConfigurationStore createStore() {
            return this.ldapConfigurationStoreBuilder.done();
        }
    }

    public class ObjectConfigurationStoreBuilder
    extends ContributingStoreBuilder {
        private final ObjectConfigurationStore store;

        public ObjectConfigurationStoreBuilder() {
            this.store = new ObjectConfigurationStore();
        }

        public ObjectConfigurationStoreBuilder(ObjectConfigurationStore store) {
            this.store = store;
        }

        public ObjectConfigurationStoreBuilder addObject(Object object) {
            this.store.addObject(object);
            return new ObjectConfigurationStoreBuilder(this.store);
        }

        @Override
        ConfigurationStore createStore() {
            return this.store;
        }
    }

    public class IniFileConfigurationStoreBuilder
    extends ContributingStoreBuilder {
        private final IniFileConfigurationStore store;

        public IniFileConfigurationStoreBuilder() {
            this.store = new IniFileConfigurationStore();
        }

        public IniFileConfigurationStoreBuilder(IniFileConfigurationStore store) {
            this.store = store;
        }

        public IniFileConfigurationStoreBuilder addResource(Resource resource) {
            this.store.addResource(resource);
            return new IniFileConfigurationStoreBuilder(this.store);
        }

        @Override
        ConfigurationStore createStore() {
            return this.store;
        }
    }

    public class EncryptedPropertiesStoreBuilder
    extends ContributingStoreBuilder {
        private final EncryptedPropertiesStore store;

        public EncryptedPropertiesStoreBuilder(String passwordProperty) {
            this.store = new EncryptedPropertiesStore(passwordProperty);
        }

        private EncryptedPropertiesStoreBuilder(EncryptedPropertiesStore store) {
            this.store = store;
        }

        public EncryptedPropertiesStoreBuilder addResource(Resource resource) {
            this.store.addResource(resource);
            return new EncryptedPropertiesStoreBuilder(this.store);
        }

        @Override
        ConfigurationStore createStore() {
            return this.store;
        }
    }

    public class YamlStoreBuilder
    extends ContributingStoreBuilder {
        private final YamlStore store;

        public YamlStoreBuilder() {
            this.store = new YamlStore();
        }

        private YamlStoreBuilder(YamlStore store) {
            this.store = store;
        }

        public YamlStoreBuilder addResource(Resource resource, String key, String ... tags) {
            return new YamlStoreBuilder(this.store.addResource(resource, key, tags));
        }

        @Override
        ConfigurationStore createStore() {
            return this.store;
        }
    }

    public class JsonStoreBuilder
    extends ContributingStoreBuilder {
        private final JsonStore store;

        public JsonStoreBuilder() {
            this.store = new JsonStore();
        }

        private JsonStoreBuilder(JsonStore store) {
            this.store = store;
        }

        public JsonStoreBuilder addResource(Resource resource, String key, String ... tags) {
            return new JsonStoreBuilder(this.store.addResource(resource, key, tags));
        }

        @Override
        ConfigurationStore createStore() {
            return this.store;
        }
    }

    public class PropertiesStoreBuilder
    extends ContributingStoreBuilder {
        private final PropertiesStore store;

        public PropertiesStoreBuilder() {
            this.store = new PropertiesStore();
        }

        private PropertiesStoreBuilder(PropertiesStore store) {
            this.store = store;
        }

        public PropertiesStoreBuilder addResource(Resource resource) {
            this.store.addResource(resource);
            return new PropertiesStoreBuilder(this.store);
        }

        @Override
        ConfigurationStore createStore() {
            return this.store;
        }
    }

    private abstract class ContributingStoreBuilder
    implements StoreBuilder {
        private ContributingStoreBuilder() {
        }

        abstract ConfigurationStore createStore();

        @Override
        public final ConstrettoBuilder done() {
            ConstrettoBuilder.this.configurationStores.add(this.createStore());
            return new ConstrettoBuilder(ConstrettoBuilder.this.configurationStores, ConstrettoBuilder.this.tags, ConstrettoBuilder.this.enableSystemProps);
        }
    }

    private static interface StoreBuilder {
        public ConstrettoBuilder done();
    }
}

