/*
 * Decompiled with CFR 0.152.
 */
package org.constretto.internal;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.Map;
import org.constretto.internal.GenericTypeResolver;
import org.constretto.internal.MethodParameter;

public abstract class GenericCollectionTypeResolver {
    public static Class<?> getCollectionFieldType(Field collectionField) {
        return GenericCollectionTypeResolver.getGenericFieldType(collectionField, Collection.class, 0, GenericCollectionTypeResolver.getNestingLevel(collectionField.getGenericType(), 0));
    }

    public static Class<?> getMapKeyFieldType(Field mapField) {
        return GenericCollectionTypeResolver.getGenericFieldType(mapField, Map.class, 0, GenericCollectionTypeResolver.getNestingLevel(mapField.getGenericType(), 0));
    }

    public static Class<?> getMapValueFieldType(Field mapField) {
        return GenericCollectionTypeResolver.getGenericFieldType(mapField, Map.class, 1, GenericCollectionTypeResolver.getNestingLevel(mapField.getGenericType(), 0));
    }

    public static Class<?> getCollectionParameterType(MethodParameter methodParam) {
        return GenericCollectionTypeResolver.getGenericParameterType(methodParam, Collection.class, 0);
    }

    public static Class<?> getMapKeyParameterType(MethodParameter methodParam) {
        return GenericCollectionTypeResolver.getGenericParameterType(methodParam, Map.class, 0);
    }

    public static Class<?> getMapValueParameterType(MethodParameter methodParam) {
        return GenericCollectionTypeResolver.getGenericParameterType(methodParam, Map.class, 1);
    }

    private static Class<?> getGenericParameterType(MethodParameter methodParam, Class<?> source, int typeIndex) {
        return GenericCollectionTypeResolver.extractType(methodParam, GenericTypeResolver.getTargetType(methodParam), source, typeIndex, methodParam.getNestingLevel(), 1);
    }

    private static Class<?> getGenericFieldType(Field field, Class<?> source, int typeIndex, int nestingLevel) {
        return GenericCollectionTypeResolver.extractType(null, field.getGenericType(), source, typeIndex, nestingLevel, 1);
    }

    static int getNestingLevel(Type type, int nestingLevel) {
        if (type instanceof ParameterizedType) {
            Type[] paramTypes = ((ParameterizedType)type).getActualTypeArguments();
            return GenericCollectionTypeResolver.getNestingLevel(paramTypes[paramTypes.length - 1], nestingLevel + 1);
        }
        return nestingLevel;
    }

    private static Class<?> extractType(MethodParameter methodParam, Type type, Class<?> source, int typeIndex, int nestingLevel, int currentLevel) {
        Type mappedType;
        Type resolvedType = type;
        if (type instanceof TypeVariable && methodParam != null && methodParam.typeVariableMap != null && (mappedType = methodParam.typeVariableMap.get((TypeVariable)type)) != null) {
            resolvedType = mappedType;
        }
        if (resolvedType instanceof ParameterizedType) {
            return GenericCollectionTypeResolver.extractTypeFromParameterizedType(methodParam, (ParameterizedType)resolvedType, source, typeIndex, nestingLevel, currentLevel);
        }
        if (resolvedType instanceof Class) {
            return GenericCollectionTypeResolver.extractTypeFromClass(methodParam, (Class)resolvedType, source, typeIndex, nestingLevel, currentLevel);
        }
        return null;
    }

    private static Class<?> extractTypeFromParameterizedType(MethodParameter methodParam, ParameterizedType ptype, Class<?> source, int typeIndex, int nestingLevel, int currentLevel) {
        Type mappedType;
        if (!(ptype.getRawType() instanceof Class)) {
            return null;
        }
        Class rawType = (Class)ptype.getRawType();
        Type[] paramTypes = ptype.getActualTypeArguments();
        if (nestingLevel - currentLevel > 0) {
            int nextLevel = currentLevel + 1;
            Integer currentTypeIndex = methodParam != null ? methodParam.getTypeIndexForLevel(nextLevel) : null;
            int indexToUse = currentTypeIndex != null ? currentTypeIndex : paramTypes.length - 1;
            Type paramType = paramTypes[indexToUse];
            return GenericCollectionTypeResolver.extractType(methodParam, paramType, null, typeIndex, nestingLevel, nextLevel);
        }
        if (source != null && !source.isAssignableFrom(rawType)) {
            return null;
        }
        Class<?> fromSuperclassOrInterface = GenericCollectionTypeResolver.extractTypeFromClass(methodParam, rawType, source, typeIndex, nestingLevel, currentLevel);
        if (fromSuperclassOrInterface != null) {
            return fromSuperclassOrInterface;
        }
        if (paramTypes == null || typeIndex >= paramTypes.length) {
            return null;
        }
        Type paramType = paramTypes[typeIndex];
        if (paramType instanceof TypeVariable && methodParam != null && methodParam.typeVariableMap != null && (mappedType = methodParam.typeVariableMap.get((TypeVariable)paramType)) != null) {
            paramType = mappedType;
        }
        if (paramType instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)paramType;
            Type[] upperBounds = wildcardType.getUpperBounds();
            if (upperBounds != null && upperBounds.length > 0 && !Object.class.equals((Object)upperBounds[0])) {
                paramType = upperBounds[0];
            } else {
                Type[] lowerBounds = wildcardType.getLowerBounds();
                if (lowerBounds != null && lowerBounds.length > 0 && !Object.class.equals((Object)lowerBounds[0])) {
                    paramType = lowerBounds[0];
                }
            }
        }
        if (paramType instanceof ParameterizedType) {
            paramType = ((ParameterizedType)paramType).getRawType();
        }
        if (paramType instanceof GenericArrayType) {
            Type compType = ((GenericArrayType)paramType).getGenericComponentType();
            if (compType instanceof Class) {
                return Array.newInstance((Class)compType, 0).getClass();
            }
        } else if (paramType instanceof Class) {
            return (Class)paramType;
        }
        return null;
    }

    private static Class<?> extractTypeFromClass(MethodParameter methodParam, Class<?> clazz, Class<?> source, int typeIndex, int nestingLevel, int currentLevel) {
        if (clazz.getName().startsWith("java.util.")) {
            return null;
        }
        if (clazz.getSuperclass() != null && GenericCollectionTypeResolver.isIntrospectionCandidate(clazz.getSuperclass())) {
            return GenericCollectionTypeResolver.extractType(methodParam, clazz.getGenericSuperclass(), source, typeIndex, nestingLevel, currentLevel);
        }
        Type[] ifcs = clazz.getGenericInterfaces();
        if (ifcs != null) {
            Type[] typeArray = ifcs;
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                Type ifc;
                Type rawType = ifc = typeArray[i];
                if (ifc instanceof ParameterizedType) {
                    rawType = ((ParameterizedType)ifc).getRawType();
                }
                if (!(rawType instanceof Class) || !GenericCollectionTypeResolver.isIntrospectionCandidate((Class)rawType)) continue;
                return GenericCollectionTypeResolver.extractType(methodParam, ifc, source, typeIndex, nestingLevel, currentLevel);
            }
        }
        return null;
    }

    private static boolean isIntrospectionCandidate(Class clazz) {
        return Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz);
    }
}

