/*
 * Decompiled with CFR 0.152.
 */
package org.constretto.internal.store;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.constretto.ConfigurationStore;
import org.constretto.exception.ConstrettoException;
import org.constretto.model.Resource;
import org.constretto.model.TaggedPropertySet;

public class JsonStore
implements ConfigurationStore {
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private Map<String, TaggedResource> resources = new HashMap<String, TaggedResource>();

    public JsonStore() {
    }

    private JsonStore(JsonStore old, String key, TaggedResource resource) {
        this.resources.putAll(old.resources);
        this.resources.put(key, resource);
    }

    public JsonStore addResource(Resource resource, String key, String ... tags) {
        ArrayList tagList = new ArrayList();
        Collections.addAll(tagList, tags);
        return new JsonStore(this, key, new TaggedResource(resource, tagList));
    }

    @Override
    public Collection<TaggedPropertySet> parseConfiguration() {
        ArrayList<TaggedPropertySet> properties = new ArrayList<TaggedPropertySet>();
        for (Map.Entry<String, TaggedResource> entry : this.resources.entrySet()) {
            TaggedResource taggedResource = entry.getValue();
            if (!taggedResource.resource.exists()) continue;
            if (taggedResource.tags.isEmpty()) {
                HashMap<String, String> property = new HashMap<String, String>();
                property.put(entry.getKey(), this.readJson(taggedResource.resource));
                properties.add(new TaggedPropertySet(property, JsonStore.class));
                continue;
            }
            for (String tag : taggedResource.tags) {
                HashMap<String, String> property = new HashMap<String, String>();
                property.put(entry.getKey(), this.readJson(taggedResource.resource));
                properties.add(new TaggedPropertySet(tag, property, JsonStore.class));
            }
        }
        return properties;
    }

    private String readJson(Resource resource) {
        try {
            int n;
            StringBuilder out = new StringBuilder();
            byte[] b = new byte[4096];
            InputStream inputStream = resource.getInputStream();
            while ((n = inputStream.read(b)) != -1) {
                out.append(new String(b, 0, n, DEFAULT_CHARSET));
            }
            return out.toString();
        }
        catch (IOException e) {
            throw new ConstrettoException("Could not read json file", (Throwable)e);
        }
    }

    private static class TaggedResource {
        public final Resource resource;
        public final List<String> tags = new ArrayList<String>();

        private TaggedResource(Resource resource, List<String> tags) {
            this.tags.addAll(tags);
            this.resource = resource;
        }
    }
}

