/*
 * Decompiled with CFR 0.152.
 */
package org.constretto.internal.store;

import com.google.gson.Gson;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.constretto.ConfigurationStore;
import org.constretto.model.Resource;
import org.constretto.model.TaggedPropertySet;
import org.yaml.snakeyaml.Yaml;

public class YamlStore
implements ConfigurationStore {
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private Map<String, TaggedResource> resources = new HashMap<String, TaggedResource>();

    public YamlStore() {
    }

    private YamlStore(YamlStore old, String key, TaggedResource resource) {
        this.resources.putAll(old.resources);
        this.resources.put(key, resource);
    }

    public YamlStore addResource(Resource resource, String key, String ... tags) {
        ArrayList tagList = new ArrayList();
        Collections.addAll(tagList, tags);
        return new YamlStore(this, key, new TaggedResource(resource, tagList));
    }

    @Override
    public Collection<TaggedPropertySet> parseConfiguration() {
        ArrayList<TaggedPropertySet> properties = new ArrayList<TaggedPropertySet>();
        for (Map.Entry<String, TaggedResource> entry : this.resources.entrySet()) {
            TaggedResource taggedResource = entry.getValue();
            if (!taggedResource.resource.exists()) continue;
            if (taggedResource.tags.isEmpty()) {
                HashMap<String, String> property = new HashMap<String, String>();
                property.put(entry.getKey(), this.yamlToJson(taggedResource.resource));
                properties.add(new TaggedPropertySet(property, YamlStore.class));
                continue;
            }
            for (String tag : taggedResource.tags) {
                HashMap<String, String> property = new HashMap<String, String>();
                property.put(entry.getKey(), this.yamlToJson(taggedResource.resource));
                properties.add(new TaggedPropertySet(tag, property, YamlStore.class));
            }
        }
        return properties;
    }

    private String yamlToJson(Resource resource) {
        Yaml yaml = new Yaml();
        Map data = (Map)yaml.loadAs((Reader)new InputStreamReader(resource.getInputStream(), DEFAULT_CHARSET), Map.class);
        return new Gson().toJson((Object)data);
    }

    private static class TaggedResource {
        public final Resource resource;
        public final List<String> tags = new ArrayList<String>();

        private TaggedResource(Resource resource, List<String> tags) {
            this.tags.addAll(tags);
            this.resource = resource;
        }
    }
}

