/*
 * Decompiled with CFR 0.152.
 */
package org.constretto.internal.store.ldap;

import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import org.constretto.exception.ConstrettoException;
import org.constretto.internal.store.ldap.LdapConfigurationStore;

public class LdapConfigurationStoreBuilder {
    public static final String NULL_ARGUMENT = "The \"%1$s\" argument can not be null";
    private DirContext dirContext;
    private LdapConfigurationStore ldapConfigurationStore = new LdapConfigurationStore();

    private LdapConfigurationStoreBuilder(DirContext dirContext) {
        this.dirContext = dirContext;
    }

    public static LdapConfigurationStoreBuilder usingDirContext(DirContext dirContext) {
        return new LdapConfigurationStoreBuilder(dirContext);
    }

    private Attributes readAttributesFromLdap(String distinguishedName) {
        try {
            return this.dirContext.getAttributes(this.createName(distinguishedName));
        }
        catch (NamingException e) {
            throw new ConstrettoException(String.format("Could not find LDAP attributes for DSN \"%1$s\"", distinguishedName), (Throwable)e);
        }
    }

    public LdapConfigurationStoreBuilder addDsnWithKey(String key, String distinguishedName, String ... tags) {
        this.checkStringArgument("distinguishedName", distinguishedName);
        this.ldapConfigurationStore = new LdapConfigurationStore(this.ldapConfigurationStore, key, this.readAttributesFromLdap(distinguishedName), tags);
        return this;
    }

    public LdapConfigurationStoreBuilder addDsn(String distinguishedName, String ... tags) {
        this.checkStringArgument("distinguishedName", distinguishedName);
        this.ldapConfigurationStore = new LdapConfigurationStore(this.ldapConfigurationStore, this.readAttributesFromLdap(distinguishedName), tags);
        return this;
    }

    public LdapConfigurationStoreBuilder addUsingSearch(String searchBase, String filter, String keyAttribute, String ... tags) {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        try {
            NamingEnumeration<SearchResult> searchResultNamingEnumeration = this.dirContext.search(this.createName(searchBase), filter, searchControls);
            while (searchResultNamingEnumeration.hasMore()) {
                SearchResult result = searchResultNamingEnumeration.next();
                Attributes attributes = result.getAttributes();
                Attribute attribute = attributes.get(keyAttribute);
                if (attribute == null) {
                    throw new ConstrettoException(String.format("The LDAP object \"%1$s\" has no attribute value for attribute \"%2$s\"", result.getName(), keyAttribute));
                }
                String key = attribute.get().toString();
                this.ldapConfigurationStore = new LdapConfigurationStore(this.ldapConfigurationStore, key, attributes, tags);
            }
        }
        catch (NamingException e) {
            throw new ConstrettoException(String.format("An error occurred while searching LDAP using searchBase \"%1$s\" and filter \"%2$s\"", searchBase, filter), (Throwable)e);
        }
        return this;
    }

    public LdapConfigurationStore done() {
        return this.ldapConfigurationStore;
    }

    private Name createName(String distinguishedName) {
        try {
            return new LdapName(distinguishedName);
        }
        catch (InvalidNameException e) {
            throw new IllegalArgumentException(String.format("Provided value \"%1$s\" is not a valid LDAP DSN", distinguishedName));
        }
    }

    private void checkStringArgument(String fieldName, String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format(NULL_ARGUMENT, fieldName));
        }
    }
}

