/*
 * Decompiled with CFR 0.152.
 */
package org.constretto.spring;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.constretto.exception.ConstrettoException;
import org.constretto.spring.annotation.Environment;
import org.constretto.spring.internal.ConstrettoAutowireCandidateResolver;
import org.constretto.spring.resolver.AssemblyContextResolver;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvironmentAnnotationConfigurer
implements BeanFactoryPostProcessor {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final AssemblyContextResolver assemblyContextResolver;
    public static final String INCLUDE_IN_COLLECTIONS = "includeInCollections";

    public EnvironmentAnnotationConfigurer(AssemblyContextResolver assemblyContextResolver) {
        this.assemblyContextResolver = assemblyContextResolver;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
        if (!(configurableListableBeanFactory instanceof DefaultListableBeanFactory)) {
            throw new IllegalStateException("EnvironmentAnnotationConfigurer needs to operate on a DefaultListableBeanFactory");
        }
        DefaultListableBeanFactory defaultListableBeanFactory = (DefaultListableBeanFactory)configurableListableBeanFactory;
        defaultListableBeanFactory.setAutowireCandidateResolver((AutowireCandidateResolver)new ConstrettoAutowireCandidateResolver());
        String[] beanNames = configurableListableBeanFactory.getBeanDefinitionNames();
        int lowestDiscoveredPriority = Integer.MAX_VALUE;
        for (String beanName : beanNames) {
            BeanDefinition beanDefinition = configurableListableBeanFactory.getBeanDefinition(beanName);
            if (beanDefinition.getBeanClassName() == null) continue;
            try {
                Class<?> beanClass = Class.forName(beanDefinition.getBeanClassName());
                Environment environmentAnnotation = this.findEnvironmentAnnotation(beanClass);
                if (environmentAnnotation == null) continue;
                if (!this.assemblyContextResolver.getAssemblyContext().isEmpty()) {
                    boolean autowireCandidate = this.decideIfAutowireCandiate(beanName, environmentAnnotation);
                    beanDefinition.setAutowireCandidate(autowireCandidate);
                    if (!autowireCandidate) continue;
                    this.removeNonAnnotatedBeansFromAutowireForType(beanClass, configurableListableBeanFactory);
                    continue;
                }
                beanDefinition.setAutowireCandidate(false);
            }
            catch (ClassNotFoundException e) {
                throw new ConstrettoException("Could not instanciateclass [" + beanDefinition.getBeanClassName() + "] for bean [" + beanName + "]", (Throwable)e);
            }
        }
    }

    private Environment findEnvironmentAnnotation(Class beanClass) {
        if (beanClass.isAnnotationPresent(Environment.class)) {
            return beanClass.getAnnotation(Environment.class);
        }
        return this.findEnvironmentMetaAnnotation(new HashSet<Annotation>(), beanClass.getAnnotations());
    }

    private Environment findEnvironmentMetaAnnotation(Set<Annotation> visited, Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (annotation instanceof Environment) {
                return (Environment)annotation;
            }
            if (visited.contains(annotation)) continue;
            visited.add(annotation);
            Environment environment = this.findEnvironmentMetaAnnotation(visited, annotation.annotationType().getAnnotations());
            if (environment == null) continue;
            return environment;
        }
        return null;
    }

    private void removeNonAnnotatedBeansFromAutowireForType(Class lookupClass, ConfigurableListableBeanFactory configurableListableBeanFactory) throws ClassNotFoundException {
        Class<?>[] interfaces;
        ArrayList<String> beanNames = new ArrayList<String>();
        for (Class<?> anInterface : interfaces = lookupClass.getInterfaces()) {
            beanNames.addAll(Arrays.asList(BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)configurableListableBeanFactory, anInterface)));
        }
        ArrayList<BeanDefinition> potentialMatches = new ArrayList<BeanDefinition>();
        for (String beanName : beanNames) {
            BeanDefinition beanDefinition = configurableListableBeanFactory.getBeanDefinition(beanName);
            Class<?> beanClass = Class.forName(beanDefinition.getBeanClassName());
            beanDefinition.setAttribute(INCLUDE_IN_COLLECTIONS, beanClass.getInterfaces());
            Environment environmentAnnotation = this.findEnvironmentAnnotation(beanClass);
            if (environmentAnnotation == null) {
                beanDefinition.setAutowireCandidate(false);
                continue;
            }
            potentialMatches.add(beanDefinition);
        }
        if (potentialMatches.size() == 1) {
            ((BeanDefinition)potentialMatches.get(0)).setAutowireCandidate(true);
        } else {
            List<BeanDefinition> highestPriorityBeans = new ArrayList<BeanDefinition>();
            for (BeanDefinition potentialMatch : potentialMatches) {
                if (!potentialMatch.isAutowireCandidate()) continue;
                potentialMatch.setAutowireCandidate(false);
                highestPriorityBeans = this.prioritizeBeans(potentialMatch, highestPriorityBeans);
            }
            if (highestPriorityBeans.size() == 1) {
                ((BeanDefinition)highestPriorityBeans.get(0)).setAutowireCandidate(true);
            } else {
                ArrayList<String> equalPriorityBeans = new ArrayList<String>();
                for (BeanDefinition highestPriorityBean : highestPriorityBeans) {
                    equalPriorityBeans.add(highestPriorityBean.getBeanClassName());
                }
                throw new ConstrettoException("More than one bean with the class or interface + [" + lookupClass.getSimpleName() + "] registered with same tag. Could not resolve priority. To fix this, remove one of the following beans " + ((Object)equalPriorityBeans).toString());
            }
        }
    }

    private List<BeanDefinition> prioritizeBeans(BeanDefinition potentialMatch, List<BeanDefinition> highestPriorityBeans) throws ClassNotFoundException {
        ArrayList<BeanDefinition> result = new ArrayList<BeanDefinition>();
        int matchPriority = this.getAutowirePriority(Class.forName(potentialMatch.getBeanClassName()));
        if (highestPriorityBeans.isEmpty()) {
            result.add(potentialMatch);
        } else {
            for (BeanDefinition highestPriorityBean : highestPriorityBeans) {
                int mostSpesificPriority = this.getAutowirePriority(Class.forName(highestPriorityBean.getBeanClassName()));
                if (matchPriority - mostSpesificPriority < 0) {
                    result.clear();
                    result.add(potentialMatch);
                    continue;
                }
                if (matchPriority - mostSpesificPriority == 0) {
                    result.add(potentialMatch);
                    result.add(highestPriorityBean);
                    continue;
                }
                result.add(highestPriorityBean);
            }
        }
        return result;
    }

    private int getAutowirePriority(Class beanClass) {
        Environment environmentAnnotation = this.findEnvironmentAnnotation(beanClass);
        if (environmentAnnotation != null) {
            List<String> environments = Arrays.asList(environmentAnnotation.value());
            List<String> assemblyContext = this.assemblyContextResolver.getAssemblyContext();
            for (int i = 0; i < assemblyContext.size(); ++i) {
                if (!environments.contains(assemblyContext.get(i))) continue;
                return i;
            }
        }
        return Integer.MAX_VALUE;
    }

    private boolean decideIfAutowireCandiate(String beanName, final Environment environmentAnnotation) {
        boolean autowireCandidate;
        ArrayList<String> targetEnvironments = new ArrayList<String>(){
            {
                this.addAll(Arrays.asList(environmentAnnotation.value()));
            }
        };
        this.validateAnnotationValues(beanName, (List<String>)targetEnvironments);
        List<String> assemblyContext = this.assemblyContextResolver.getAssemblyContext();
        targetEnvironments.retainAll(assemblyContext);
        boolean bl = autowireCandidate = !targetEnvironments.isEmpty();
        if (autowireCandidate) {
            this.logger.info((Object)(beanName + " is annotated with environment '" + environmentAnnotation.value() + "', and is selected for autowiring in the current environment '" + this.assemblyContextResolver.getAssemblyContext() + "'"));
        } else {
            this.logger.info((Object)(beanName + " is annotated with environment '" + environmentAnnotation.value() + "', and is discarded for autowiring in the current environment '" + this.assemblyContextResolver.getAssemblyContext() + "'"));
        }
        return autowireCandidate;
    }

    private void validateAnnotationValues(String beanName, List<String> beanEnvironments) {
        if (beanEnvironments.isEmpty()) {
            throw new ConstrettoException("You must specify environment tags in @Environment. offending bean: " + beanName);
        }
    }
}

