/*
 * Decompiled with CFR 0.152.
 */
package org.constretto.spring.internal;

import java.util.ArrayList;
import java.util.List;
import org.constretto.ConstrettoBuilder;
import org.constretto.ConstrettoConfiguration;
import org.constretto.internal.ConstrettoUtils;
import org.constretto.internal.resolver.DefaultConfigurationContextResolver;
import org.constretto.model.Resource;
import org.constretto.resolver.ConfigurationContextResolver;
import org.constretto.spring.ConfigurationAnnotationConfigurer;
import org.constretto.spring.ConstrettoConfigurationFactoryBean;
import org.constretto.spring.ConstrettoPropertyPlaceholderConfigurer;
import org.constretto.spring.EnvironmentAnnotationConfigurer;
import org.constretto.spring.internal.resolver.DefaultAssemblyContextResolver;
import org.constretto.spring.resolver.AssemblyContextResolver;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.Assert;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConstrettoNamespaceHandler
extends NamespaceHandlerSupport {
    private static final String CONFIGURATION_CONTEXT_RESOLVER_NAME = "constretto:configurationContextResolver";
    private static final String ENVIRONMENT_CONTEXT_RESOLVER_NAME = "constretto:assemblyContextResolver";
    private static final String CONSTRETTO_CONFIGURATION_BEAN_NAME = "constretto:constrettoConfiguration";
    private static final String CONSTRETTO_PLACEHOLDER_BEAN_NAME = "constretto:constrettoPlaceholderConfigurer";
    private static final String CONSTRETTO_CONFIGURATION_ANNOTATION_BEAN_NAME = "constretto:configurationAnnotationConfigurer";
    private static final String CONSTRETTO_ENVIRONMENT_ANNOTATION_BEAN_NAME = "constretto:environmentAnnotationConfigurer";

    public void init() {
        this.registerBeanDefinitionParser("configuration", new ConfigurationDefinitionParser());
        this.registerBeanDefinitionParser("import", new ImportDefinitionParser());
        this.registerBeanDefinitionParser("property-placeholder-configurer", new PropertyPlaceHolderDefinitionParser());
        this.registerBeanDefinitionParser("annotation-config", new AnnotationConfigDefinitionParser());
    }

    private void createPropertyPlaceholder(ConstrettoConfiguration configuration, ParserContext parserContext, Element propertyPlaceholderElement) {
        BeanDefinitionBuilder placeHolderBean = BeanDefinitionBuilder.rootBeanDefinition(ConstrettoPropertyPlaceholderConfigurer.class);
        if (configuration != null) {
            placeHolderBean.addConstructorArgValue((Object)configuration);
        } else {
            placeHolderBean.addConstructorArgReference(CONSTRETTO_CONFIGURATION_BEAN_NAME);
        }
        if (propertyPlaceholderElement != null) {
            boolean ignoreUnresolved = propertyPlaceholderElement.getAttribute("ignore-unresolved-placeholders") != null ? Boolean.valueOf(propertyPlaceholderElement.getAttribute("ignore-unresolved-placeholders")) : false;
            String prefix = propertyPlaceholderElement.getAttribute("prefix") != null ? propertyPlaceholderElement.getAttribute("prefix") : "${";
            String suffix = propertyPlaceholderElement.getAttribute("suffix") != null ? propertyPlaceholderElement.getAttribute("suffix") : "}";
            placeHolderBean.addPropertyValue("placeholderPrefix", (Object)prefix);
            placeHolderBean.addPropertyValue("placeholderSuffix", (Object)suffix);
            placeHolderBean.addPropertyValue("ignoreUnresolvablePlaceholders", (Object)ignoreUnresolved);
        }
        parserContext.getRegistry().registerBeanDefinition(CONSTRETTO_PLACEHOLDER_BEAN_NAME, (BeanDefinition)placeHolderBean.getBeanDefinition());
    }

    private void createAnnotationConfigBean(ConstrettoConfiguration configuration, AssemblyContextResolver assemblyContextResolver, ParserContext parserContext) {
        BeanDefinitionBuilder configurationAnnotationConfigurerBean = BeanDefinitionBuilder.rootBeanDefinition(ConfigurationAnnotationConfigurer.class);
        if (configuration != null) {
            configurationAnnotationConfigurerBean.addConstructorArgValue((Object)configuration);
        } else {
            configurationAnnotationConfigurerBean.addConstructorArgReference(CONSTRETTO_CONFIGURATION_BEAN_NAME);
        }
        if (assemblyContextResolver != null) {
            configurationAnnotationConfigurerBean.addConstructorArgValue((Object)assemblyContextResolver);
        } else {
            configurationAnnotationConfigurerBean.addConstructorArgReference(ENVIRONMENT_CONTEXT_RESOLVER_NAME);
        }
        parserContext.getRegistry().registerBeanDefinition(CONSTRETTO_CONFIGURATION_ANNOTATION_BEAN_NAME, (BeanDefinition)configurationAnnotationConfigurerBean.getBeanDefinition());
        BeanDefinitionBuilder environmentAnnotationConfigurerBean = BeanDefinitionBuilder.rootBeanDefinition(EnvironmentAnnotationConfigurer.class);
        environmentAnnotationConfigurerBean.addConstructorArgValue((Object)assemblyContextResolver);
        parserContext.getRegistry().registerBeanDefinition(CONSTRETTO_ENVIRONMENT_ANNOTATION_BEAN_NAME, (BeanDefinition)environmentAnnotationConfigurerBean.getBeanDefinition());
    }

    private class AnnotationConfigDefinitionParser
    implements BeanDefinitionParser {
        private AnnotationConfigDefinitionParser() {
        }

        public BeanDefinition parse(Element element, ParserContext parserContext) {
            ConstrettoNamespaceHandler.this.createAnnotationConfigBean(null, null, parserContext);
            return null;
        }
    }

    private class PropertyPlaceHolderDefinitionParser
    implements BeanDefinitionParser {
        private PropertyPlaceHolderDefinitionParser() {
        }

        public BeanDefinition parse(Element element, ParserContext parserContext) {
            ConstrettoNamespaceHandler.this.createPropertyPlaceholder(null, parserContext, element);
            return null;
        }
    }

    private class ImportDefinitionParser
    implements BeanDefinitionParser {
        private ImportDefinitionParser() {
        }

        public BeanDefinition parse(Element element, ParserContext parserContext) {
            boolean include;
            AssemblyContextResolver assemblyContextResolver;
            String targetEnvironmentsCsv = element.getAttribute("environments");
            String resourcePath = element.getAttribute("resource");
            List targetEnvironments = ConstrettoUtils.fromCSV((String)targetEnvironmentsCsv);
            if (parserContext.getRegistry().containsBeanDefinition(ConstrettoNamespaceHandler.ENVIRONMENT_CONTEXT_RESOLVER_NAME)) {
                BeanDefinition environmentContextResolverBeanDefinition = parserContext.getRegistry().getBeanDefinition(ConstrettoNamespaceHandler.ENVIRONMENT_CONTEXT_RESOLVER_NAME);
                String environmentResolverClassName = environmentContextResolverBeanDefinition.getBeanClassName();
                try {
                    assemblyContextResolver = (AssemblyContextResolver)Class.forName(environmentResolverClassName).newInstance();
                }
                catch (Exception e) {
                    throw new IllegalStateException("Could not instansiate assembly context resolver with class [" + environmentResolverClassName + "]", e);
                }
            } else {
                assemblyContextResolver = new DefaultAssemblyContextResolver();
            }
            List<String> assemblyContext = assemblyContextResolver.getAssemblyContext();
            targetEnvironments.retainAll(assemblyContext);
            boolean bl = include = !targetEnvironments.isEmpty();
            if (include) {
                parserContext.getReaderContext().getReader().loadBeanDefinitions(resourcePath);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConfigurationDefinitionParser
    implements BeanDefinitionParser {
        private ConfigurationDefinitionParser() {
        }

        public BeanDefinition parse(Element element, ParserContext parserContext) {
            ConfigurationContextResolver configurationContextResolver = this.processConfigurationContextResolverTag(DomUtils.getChildElementByTagName((Element)element, (String)"configuration-context-resolver"), parserContext);
            AssemblyContextResolver assemblyContextResolver = this.processAssemblyContextResolverTag(DomUtils.getChildElementByTagName((Element)element, (String)"assembly-context-resolver"), parserContext);
            ConstrettoConfiguration configuration = this.buildConfig(element, configurationContextResolver);
            this.processAnnotationConfig(element, configuration, assemblyContextResolver, parserContext);
            this.processPropertyPlaceHolder(element, configuration, parserContext);
            BeanDefinitionBuilder configurationFactoryBean = BeanDefinitionBuilder.rootBeanDefinition(ConstrettoConfigurationFactoryBean.class);
            configurationFactoryBean.addConstructorArgValue((Object)configuration);
            parserContext.getRegistry().registerBeanDefinition(ConstrettoNamespaceHandler.CONSTRETTO_CONFIGURATION_BEAN_NAME, (BeanDefinition)configurationFactoryBean.getBeanDefinition());
            return null;
        }

        private ConstrettoConfiguration buildConfig(Element element, ConfigurationContextResolver configurationContextResolver) {
            ConstrettoBuilder builder = new ConstrettoBuilder(configurationContextResolver, true);
            Element storeElement = DomUtils.getChildElementByTagName((Element)element, (String)"stores");
            if (storeElement != null) {
                List<Element> stores = this.getAllChildElements(storeElement);
                for (Element store : stores) {
                    String location;
                    List resources;
                    ConstrettoBuilder.PropertiesStoreBuilder propertiesBuilder;
                    String tagName = store.getLocalName();
                    if ("properties-store".equals(tagName)) {
                        propertiesBuilder = builder.createPropertiesStore();
                        resources = DomUtils.getChildElementsByTagName((Element)store, (String)"resource");
                        for (Element resource : resources) {
                            location = resource.getAttribute("location");
                            propertiesBuilder.addResource(new Resource(location));
                        }
                        propertiesBuilder.done();
                        continue;
                    }
                    if ("encrypted-properties-store".equals(tagName)) {
                        propertiesBuilder = builder.createEncryptedPropertiesStore(store.getAttribute("password-property"));
                        resources = DomUtils.getChildElementsByTagName((Element)store, (String)"resource");
                        for (Element resource : resources) {
                            location = resource.getAttribute("location");
                            propertiesBuilder.addResource(new Resource(location));
                        }
                        propertiesBuilder.done();
                        continue;
                    }
                    if ("ini-store".equals(tagName)) {
                        ConstrettoBuilder.IniFileConfigurationStoreBuilder iniBuilder = builder.createIniFileConfigurationStore();
                        resources = DomUtils.getChildElementsByTagName((Element)store, (String)"resource");
                        for (Element resource : resources) {
                            location = resource.getAttribute("location");
                            iniBuilder.addResource(new Resource(location));
                        }
                        iniBuilder.done();
                        continue;
                    }
                    if ("system-properties-store".equals(tagName)) {
                        builder.createSystemPropertiesStore();
                        continue;
                    }
                    if (!"object-store".equals(tagName)) continue;
                    ConstrettoBuilder.ObjectConfigurationStoreBuilder objectBuilder = builder.createObjectConfigurationStore();
                    List objects = DomUtils.getChildElementsByTagName((Element)store, (String)"object");
                    for (Element object : objects) {
                        String clazz = object.getAttribute("class");
                        try {
                            objectBuilder.addObject(Class.forName(clazz).newInstance());
                        }
                        catch (Exception e) {
                            throw new IllegalStateException("Could not instansiate configuration source object with class [" + clazz + "]");
                        }
                    }
                    objectBuilder.done();
                }
            }
            return builder.getConfiguration();
        }

        private void processPropertyPlaceHolder(Element element, ConstrettoConfiguration configuration, ParserContext parserContext) {
            boolean enabled;
            String propertyPlaceholderAttribute = element.getAttribute("property-placeholder");
            Element propertyPlaceholderElement = DomUtils.getChildElementByTagName((Element)element, (String)"property-placeholder-configurer");
            boolean bl = enabled = propertyPlaceholderAttribute != null ? Boolean.valueOf(propertyPlaceholderAttribute) : true;
            if (enabled) {
                ConstrettoNamespaceHandler.this.createPropertyPlaceholder(configuration, parserContext, propertyPlaceholderElement);
            }
        }

        private void processAnnotationConfig(Element element, ConstrettoConfiguration configuration, AssemblyContextResolver assemblyContextResolver, ParserContext parserContext) {
            boolean enabled;
            String annotationConfigAttribute = element.getAttribute("annotation-config");
            boolean bl = enabled = annotationConfigAttribute != null ? Boolean.valueOf(annotationConfigAttribute) : true;
            if (enabled) {
                ConstrettoNamespaceHandler.this.createAnnotationConfigBean(configuration, assemblyContextResolver, parserContext);
            }
        }

        private ConfigurationContextResolver processConfigurationContextResolverTag(Element element, ParserContext parserContext) {
            if (element == null) {
                BeanDefinitionBuilder contextResolverBean = BeanDefinitionBuilder.rootBeanDefinition(DefaultConfigurationContextResolver.class);
                parserContext.getRegistry().registerBeanDefinition(ConstrettoNamespaceHandler.CONFIGURATION_CONTEXT_RESOLVER_NAME, (BeanDefinition)contextResolverBean.getBeanDefinition());
                return new DefaultConfigurationContextResolver();
            }
            String clazz = element.getAttribute("class");
            BeanDefinitionBuilder contextResolverBean = BeanDefinitionBuilder.rootBeanDefinition((String)clazz);
            parserContext.getRegistry().registerBeanDefinition(ConstrettoNamespaceHandler.CONFIGURATION_CONTEXT_RESOLVER_NAME, (BeanDefinition)contextResolverBean.getBeanDefinition());
            try {
                return (ConfigurationContextResolver)Class.forName(clazz).newInstance();
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not instansiate configuration context resolver with class [" + clazz + "]", e);
            }
        }

        private AssemblyContextResolver processAssemblyContextResolverTag(Element element, ParserContext parserContext) {
            if (element == null) {
                BeanDefinitionBuilder contextResolverBean = BeanDefinitionBuilder.rootBeanDefinition(DefaultAssemblyContextResolver.class);
                parserContext.getRegistry().registerBeanDefinition(ConstrettoNamespaceHandler.ENVIRONMENT_CONTEXT_RESOLVER_NAME, (BeanDefinition)contextResolverBean.getBeanDefinition());
                return new DefaultAssemblyContextResolver();
            }
            String clazz = element.getAttribute("class");
            BeanDefinitionBuilder contextResolverBean = BeanDefinitionBuilder.rootBeanDefinition((String)clazz);
            parserContext.getRegistry().registerBeanDefinition(ConstrettoNamespaceHandler.ENVIRONMENT_CONTEXT_RESOLVER_NAME, (BeanDefinition)contextResolverBean.getBeanDefinition());
            try {
                return (AssemblyContextResolver)Class.forName(clazz).newInstance();
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not instansiate assembly context resolver with class [" + clazz + "]", e);
            }
        }

        public List<Element> getAllChildElements(Element element) {
            Assert.notNull((Object)element, (String)"Element must not be null");
            NodeList childNodes = element.getChildNodes();
            ArrayList<Element> childElements = new ArrayList<Element>();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node node = childNodes.item(i);
                if (!(node instanceof Element)) continue;
                childElements.add((Element)node);
            }
            return childElements;
        }
    }
}

