/*
 * Decompiled with CFR 0.152.
 */
package org.constretto.spring.internal.converter;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.constretto.ValueConverter;
import org.constretto.exception.ConstrettoConversionException;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringResourceValueConverter
implements ValueConverter<Resource> {
    private final Type listType = new TypeToken<List<String>>(){}.getType();
    private final Gson gson = new Gson();

    public Resource fromString(String value) throws ConstrettoConversionException {
        return new DefaultResourceLoader(this.getClass().getClassLoader()).getResource(value);
    }

    public List<Resource> fromStrings(String value) throws ConstrettoConversionException {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        List strings = (List)this.gson.fromJson(value, this.listType);
        for (String string : strings) {
            resources.add(this.fromString(string));
        }
        return resources;
    }
}

