/*
 * Decompiled with CFR 0.152.
 */
package org.constretto.spring;

import java.lang.reflect.Field;
import org.constretto.ConstrettoConfiguration;
import org.constretto.spring.annotation.Environment;
import org.constretto.spring.resolver.AssemblyContextResolver;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;

public class ConfigurationAnnotationConfigurer
extends InstantiationAwareBeanPostProcessorAdapter {
    private ConstrettoConfiguration configuration;
    private AssemblyContextResolver assemblyContextResolver;

    public ConfigurationAnnotationConfigurer(ConstrettoConfiguration configuration, AssemblyContextResolver assemblyContextResolver) {
        this.configuration = configuration;
        this.assemblyContextResolver = assemblyContextResolver;
    }

    public boolean postProcessAfterInstantiation(Object bean, String beanName) throws BeansException {
        this.injectConfiguration(bean);
        this.injectEnvironment(bean);
        return true;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    private void injectEnvironment(Object bean) {
        try {
            Field[] fields;
            for (Field field : fields = bean.getClass().getDeclaredFields()) {
                if (!field.isAnnotationPresent(Environment.class)) continue;
                field.setAccessible(true);
                field.set(bean, this.assemblyContextResolver.getAssemblyContext());
            }
        }
        catch (IllegalAccessException e) {
            throw new BeanInstantiationException(bean.getClass(), "Could not inject Environment on spring bean");
        }
    }

    private void injectConfiguration(Object bean) {
        this.configuration.on(bean);
    }
}

