/*
 * Decompiled with CFR 0.152.
 */
package org.constretto.spring;

import java.util.Iterator;
import java.util.Map;
import org.constretto.spring.internal.resolver.DefaultAssemblyContextResolver;
import org.constretto.spring.resolver.AssemblyContextResolver;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;

public class ConstrettoSingletonFactoryBean
implements FactoryBean {
    private Map<String, Object> beans;
    private Object defaultBean;
    private AssemblyContextResolver assemblyContextResolver;

    private ConstrettoSingletonFactoryBean() {
        this.assemblyContextResolver = new DefaultAssemblyContextResolver();
    }

    public ConstrettoSingletonFactoryBean(Map<String, Object> beans, Object defaultBean) {
        this();
        this.beans = beans;
        this.defaultBean = defaultBean;
    }

    public ConstrettoSingletonFactoryBean(Map<String, Object> beans) {
        this();
        this.beans = beans;
    }

    public ConstrettoSingletonFactoryBean(Map<String, Object> beans, AssemblyContextResolver assemblyContextResolver) {
        this.assemblyContextResolver = assemblyContextResolver;
        this.beans = beans;
    }

    public ConstrettoSingletonFactoryBean(Map<String, Object> beans, Object defaultBean, AssemblyContextResolver assemblyContextResolver) {
        this.assemblyContextResolver = assemblyContextResolver;
        this.beans = beans;
        this.defaultBean = defaultBean;
    }

    public Object getObject() throws Exception {
        if (null == this.beans && null == this.defaultBean) {
            throw new BeanInitializationException("At least one implementation of the service is mandatory");
        }
        return this.getResolvedBean();
    }

    @Autowired
    public void setAssemblyContextResolver(AssemblyContextResolver assemblyContextResolver) {
        this.assemblyContextResolver = assemblyContextResolver;
    }

    public void setDefaultBean(Object defaultBean) {
        this.defaultBean = defaultBean;
    }

    private Object getResolvedBean() {
        Object bean = null;
        if (!this.assemblyContextResolver.getAssemblyContext().isEmpty()) {
            String currentEnvironment;
            Iterator<String> i$ = this.assemblyContextResolver.getAssemblyContext().iterator();
            while (i$.hasNext() && null == (bean = this.beans.get(currentEnvironment = i$.next()))) {
            }
        }
        if (bean == null) {
            bean = this.defaultBean;
        }
        if (bean == null) {
            throw new BeanInitializationException("No bean assosiated with the prefix " + this.assemblyContextResolver.getAssemblyContext() + ", and no default bean could be found");
        }
        return bean;
    }

    public Class<?> getObjectType() {
        if (null == this.beans) {
            throw new BeanInitializationException("At least one implementation of the service is mandatory");
        }
        return this.getResolvedBean().getClass();
    }

    public boolean isSingleton() {
        return false;
    }
}

