/*
 * Decompiled with CFR 0.152.
 */
package org.constretto.spring.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.constretto.ConstrettoConfiguration;
import org.constretto.exception.ConstrettoException;
import org.constretto.spring.ConfigurationAnnotationConfigurer;
import org.constretto.spring.ConstrettoPropertyPlaceholderConfigurer;
import org.constretto.spring.annotation.Constretto;
import org.constretto.spring.internal.resolver.DefaultAssemblyContextResolver;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;

public class ConstrettoImportRegistrar
implements ImportBeanDefinitionRegistrar {
    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        ConstrettoConfiguration constrettoConfiguration = this.getConstrettoConfigurationForConfigurationClass(importingClassMetadata.getClassName());
        AnnotationAttributes annotationAttributes = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(Constretto.class.getName()));
        if (annotationAttributes.getBoolean("enablePropertyPlaceholder")) {
            registry.registerBeanDefinition(ConstrettoPropertyPlaceholderConfigurer.class.getName(), this.createPropertyPlaceholderBeanDefinition(constrettoConfiguration));
        }
        if (annotationAttributes.getBoolean("enableAnnotationSupport")) {
            registry.registerBeanDefinition(ConfigurationAnnotationConfigurer.class.getName(), this.createConfigurationAnnotationConfigurerBeanDefinition(constrettoConfiguration));
        }
    }

    private BeanDefinition createConfigurationAnnotationConfigurerBeanDefinition(ConstrettoConfiguration constrettoConfiguration) {
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClass(ConfigurationAnnotationConfigurer.class);
        ConstructorArgumentValues argumentValues = new ConstructorArgumentValues();
        argumentValues.addIndexedArgumentValue(0, (Object)constrettoConfiguration);
        argumentValues.addIndexedArgumentValue(1, (Object)new DefaultAssemblyContextResolver());
        beanDefinition.setConstructorArgumentValues(argumentValues);
        return beanDefinition;
    }

    private BeanDefinition createPropertyPlaceholderBeanDefinition(ConstrettoConfiguration constrettoConfiguration) {
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClass(ConstrettoPropertyPlaceholderConfigurer.class);
        ConstructorArgumentValues argumentValues = new ConstructorArgumentValues();
        argumentValues.addIndexedArgumentValue(0, (Object)constrettoConfiguration);
        beanDefinition.setConstructorArgumentValues(argumentValues);
        return beanDefinition;
    }

    private ConstrettoConfiguration getConstrettoConfigurationForConfigurationClass(String className) {
        Class<?> configurationClass;
        try {
            configurationClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new ConstrettoException(String.format("Could not load configuration class \"%s\"", className), (Throwable)e);
        }
        List<Method> methods = this.findStaticNonArgsMethodsReturningConstrettoConfiguration(configurationClass);
        if (methods.isEmpty()) {
            throw new ConstrettoException("Could not find a static factory non-arg method that creates a org.constretto.ConstrettoConfiguration instance in your configuration class (or superclass). In order to use automatic setup of Constretto-Spring BeanPostProcessors you will have to define one");
        }
        if (methods.size() > 1) {
            throw new ConstrettoException("Found more than static non-arg method returning a org.constretto.ConstrettoConfiguration instance in your configuration class (or superclass). To use automatic setup of Constretto Spring BeanPostProcessors you should have only one");
        }
        Method factoryMethod = methods.get(0);
        try {
            return (ConstrettoConfiguration)factoryMethod.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new ConstrettoException(String.format("Could not invoke factory method \"%1$s\" in configuration class \"%2$s\"", factoryMethod.getName(), configurationClass.getName()), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ConstrettoException(String.format("Could not invoke factory method \"%1$s\" in configuration class \"%2$s\"", factoryMethod.getName(), configurationClass.getName()), (Throwable)e);
        }
    }

    private List<Method> findStaticNonArgsMethodsReturningConstrettoConfiguration(Class<?> configurationClass) {
        return this.filterMethodsHavingArgs(this.filterMethodsReturningByReturnTypeNotBeingConstretto(this.findPublicStaticMethods(configurationClass)));
    }

    private List<Method> filterMethodsHavingArgs(Iterable<Method> methods) {
        LinkedList<Method> nonArgsMethods = new LinkedList<Method>();
        for (Method method : methods) {
            if (method.getParameterTypes().length != 0) continue;
            nonArgsMethods.add(method);
        }
        return nonArgsMethods;
    }

    private List<Method> filterMethodsReturningByReturnTypeNotBeingConstretto(Iterable<Method> methods) {
        LinkedList<Method> constrettoMethods = new LinkedList<Method>();
        for (Method method : methods) {
            if (!ConstrettoConfiguration.class.isAssignableFrom(method.getReturnType())) continue;
            constrettoMethods.add(method);
        }
        return constrettoMethods;
    }

    private List<Method> findPublicStaticMethods(Class<?> configurationClass) {
        LinkedList<Method> staticMethods = new LinkedList<Method>();
        for (Method method : configurationClass.getMethods()) {
            if (!Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers())) continue;
            staticMethods.add(method);
        }
        return staticMethods;
    }
}

