/*
 * Decompiled with CFR 0.152.
 */
package org.constretto.spring;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.constretto.ConstrettoConfiguration;
import org.constretto.exception.ConstrettoException;
import org.constretto.internal.introspect.ArgumentDescription;
import org.constretto.internal.introspect.ArgumentDescriptionFactory;
import org.constretto.internal.introspect.Constructors;
import org.constretto.spring.annotation.Environment;
import org.constretto.spring.resolver.AssemblyContextResolver;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;

public class ConfigurationAnnotationConfigurer
extends InstantiationAwareBeanPostProcessorAdapter
implements BeanFactoryPostProcessor,
BeanFactoryAware {
    private ConstrettoConfiguration configuration;
    private AssemblyContextResolver assemblyContextResolver;
    private Map<Class<?>, Constructor<?>> configurableConstructorCache = Collections.synchronizedMap(new HashMap());
    private static final Object constructorCacheLockObject = new Object();
    private BeanFactory beanFactory;

    public ConfigurationAnnotationConfigurer(ConstrettoConfiguration configuration, AssemblyContextResolver assemblyContextResolver) {
        this.configuration = configuration;
        this.assemblyContextResolver = assemblyContextResolver;
    }

    public Constructor<?>[] determineCandidateConstructors(Class<?> beanClass, String beanName) throws BeansException {
        Constructor<?> constructor = this.configurableConstructorCache.get(beanClass);
        if (constructor == null) {
            return null;
        }
        return new Constructor[]{constructor};
    }

    public boolean postProcessAfterInstantiation(Object bean, String beanName) throws BeansException {
        try {
            if (this.beanFactory != null && this.beanFactory.isSingleton(beanName)) {
                this.injectConfiguration(bean);
                this.injectEnvironment(bean);
            }
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        return true;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    private void injectEnvironment(Object bean) {
        try {
            Field[] fields;
            for (Field field : fields = bean.getClass().getDeclaredFields()) {
                if (!field.isAnnotationPresent(Environment.class)) continue;
                field.setAccessible(true);
                field.set(bean, this.assemblyContextResolver.getAssemblyContext());
            }
        }
        catch (IllegalAccessException e) {
            throw new BeanInstantiationException(bean.getClass(), "Could not inject Environment on spring bean");
        }
    }

    private void injectConfiguration(Object bean) {
        this.configuration.on(bean);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        for (String beanName : beanFactory.getBeanDefinitionNames()) {
            Constructor<?> resolvedConstructor;
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName);
            Class beanType = beanFactory.getType(beanName);
            if (!this.configurableConstructorCache.containsKey(beanType)) {
                this.configurableConstructorCache.put(beanType, this.resolveConfigurableConstructor(beanType));
            }
            if ((resolvedConstructor = this.configurableConstructorCache.get(beanType)) == null) continue;
            ConstructorArgumentValues constructorArgumentValues = beanDefinition.getConstructorArgumentValues();
            ArgumentDescription[] argumentDescriptions = ArgumentDescriptionFactory.create(resolvedConstructor).resolveParameters();
            for (int i = 0; i < argumentDescriptions.length; ++i) {
                String keyName;
                ArgumentDescription argumentDescription = argumentDescriptions[i];
                if (constructorArgumentValues.hasIndexedArgumentValue(i) || !this.configuration.hasValue(keyName = argumentDescription.constrettoConfigurationKeyCandidate())) continue;
                constructorArgumentValues.addIndexedArgumentValue(i, this.configuration.evaluateTo(argumentDescription.getType(), keyName));
            }
        }
    }

    private Constructor<?> resolveConfigurableConstructor(Class<?> beanClass) {
        Constructor[] constructorsWithConfigureAnnotation = Constructors.findConstructorsWithConfigureAnnotation(beanClass);
        if (constructorsWithConfigureAnnotation == null) {
            return null;
        }
        if (constructorsWithConfigureAnnotation.length > 1) {
            throw new ConstrettoException("You should only have one constructor annotated with @Configure");
        }
        return constructorsWithConfigureAnnotation[0];
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

