/*
 * Decompiled with CFR 0.152.
 */
package org.constretto.spring;

import java.util.Properties;
import org.constretto.ConstrettoConfiguration;
import org.constretto.ValueConverter;
import org.constretto.internal.converter.ValueConverterRegistry;
import org.constretto.spring.internal.converter.SpringResourceValueConverter;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.core.io.Resource;

public class ConstrettoPropertyPlaceholderConfigurer
extends PropertyPlaceholderConfigurer {
    private ConstrettoConfiguration configuration;
    private boolean ignoreUnresolvedPlaceHolders;

    public ConstrettoPropertyPlaceholderConfigurer(ConstrettoConfiguration configuration) {
        this.configuration = configuration;
        ValueConverterRegistry.registerCustomConverter(Resource.class, (ValueConverter)new SpringResourceValueConverter());
    }

    public void setIgnoreUnresolvablePlaceholders(boolean ignoreUnresolvablePlaceholders) {
        this.ignoreUnresolvedPlaceHolders = ignoreUnresolvablePlaceholders;
        super.setIgnoreUnresolvablePlaceholders(ignoreUnresolvablePlaceholders);
    }

    protected String resolvePlaceholder(String placeholder, Properties props, int systemPropertiesMode) {
        String value = null;
        if (this.ignoreUnresolvedPlaceHolders) {
            value = (String)this.configuration.evaluateTo(placeholder, (Object)"");
        } else if (placeholder.contains(this.valueSeparator)) {
            String placeholderValuePart = placeholder.substring(0, placeholder.indexOf(this.valueSeparator));
            String defaultValuePart = placeholder.substring(placeholder.indexOf(this.valueSeparator) + 1, placeholder.length());
            value = (String)this.configuration.evaluateTo(placeholderValuePart, (Object)defaultValuePart);
        } else {
            value = (String)this.configuration.evaluateTo(String.class, placeholder);
        }
        return null != value ? value : null;
    }
}

