/*
 * Decompiled with CFR 0.152.
 */
package org.constretto.test;

import org.constretto.internal.ConstrettoUtils;
import org.constretto.test.extractors.ConstrettoEnvironmentExtractor;
import org.constretto.test.extractors.ConstrettoTagExtractor;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class ConstrettoRule
implements TestRule {
    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                String originalTags = ConstrettoRule.this.changeTagsSystemProperty(description);
                String originalEnvironment = ConstrettoRule.this.changeEnvironmentSystemProperty(description);
                try {
                    base.evaluate();
                }
                finally {
                    if (originalTags == null) {
                        System.getProperties().remove("CONSTRETTO_TAGS");
                    } else {
                        System.setProperty("CONSTRETTO_TAGS", originalTags);
                    }
                    if (originalEnvironment == null) {
                        System.getProperties().remove("CONSTRETTO_ENV");
                    } else {
                        System.setProperty("CONSTRETTO_ENV", originalEnvironment);
                    }
                }
            }
        };
    }

    private String changeTagsSystemProperty(Description description) {
        String[] tagValue = ConstrettoTagExtractor.findTagValueForDescription(description);
        if (tagValue == null) {
            return System.getProperty("CONSTRETTO_TAGS");
        }
        return System.setProperty("CONSTRETTO_TAGS", ConstrettoUtils.asCsv((String[])tagValue));
    }

    private String changeEnvironmentSystemProperty(Description description) {
        String[] environmentsDeclared;
        if (this.constrettoEnvironmentAnnotationIsOnClasspath() && (environmentsDeclared = ConstrettoEnvironmentExtractor.extractEnvironmentValue(description)) != null) {
            return System.setProperty("CONSTRETTO_ENV", ConstrettoUtils.asCsv((String[])environmentsDeclared));
        }
        return System.getProperty("CONSTRETTO_ENV");
    }

    private boolean constrettoEnvironmentAnnotationIsOnClasspath() {
        try {
            Class.forName("org.constretto.spring.annotation.Environment");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }
}

