/*
 * Decompiled with CFR 0.152.
 */
package org.constretto.test;

import org.constretto.annotation.Tags;
import org.constretto.internal.ConstrettoUtils;
import org.constretto.spring.annotation.Environment;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

public class ConstrettoSpringJUnit4ClassRunner
extends SpringJUnit4ClassRunner {
    public ConstrettoSpringJUnit4ClassRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
    }

    public void run(RunNotifier notifier) {
        String originalTags = this.changeTagsSystemProperty();
        String originalEnvironment = this.changeAssembleSystemProperty();
        super.run(notifier);
        if (originalTags == null) {
            System.getProperties().remove("CONSTRETTO_TAGS");
        } else {
            System.setProperty("CONSTRETTO_TAGS", originalTags);
        }
        if (originalEnvironment == null) {
            System.getProperties().remove("CONSTRETTO_ENV");
        } else {
            System.setProperty("CONSTRETTO_ENV", originalEnvironment);
        }
    }

    private String changeTagsSystemProperty() {
        Tags tags = this.getTestClass().getJavaClass().getAnnotation(Tags.class);
        if (tags != null) {
            return System.setProperty("CONSTRETTO_TAGS", ConstrettoUtils.asCsv((String[])tags.value()));
        }
        return System.getProperty("CONSTRETTO_TAGS");
    }

    private String changeAssembleSystemProperty() {
        Environment environment = this.getTestClass().getJavaClass().getAnnotation(Environment.class);
        if (environment != null) {
            return System.setProperty("CONSTRETTO_ENV", ConstrettoUtils.asCsv((String[])environment.value()));
        }
        return System.getProperty("CONSTRETTO_ENV");
    }
}

