/*
 * Decompiled with CFR 0.152.
 */
package org.constretto.test.extender;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.constretto.test.extender.RuleExtender;
import org.junit.runner.Description;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class Extenders
implements AutoCloseable {
    private Set<? extends RuleExtender> extenders;

    public Extenders(Set<? extends RuleExtender> extenders) {
        this.extenders = extenders;
    }

    static Extenders createFromClasspathUsingDescription(Description testDescription) {
        Set<Class<? extends RuleExtender>> extenders = Extenders.findRuleExtenderClasses();
        HashSet extenderInstances = Sets.newHashSet((Iterable)Collections2.transform((Collection)Sets.filter(extenders, (Predicate)new Predicate<Class<? extends RuleExtender>>(){

            public boolean apply(Class<? extends RuleExtender> input) {
                try {
                    return input.getDeclaredConstructor(new Class[0]) != null;
                }
                catch (NoSuchMethodException e) {
                    return false;
                }
            }
        }), (Function)new Function<Class<? extends RuleExtender>, RuleExtender>(){

            @Nullable
            public RuleExtender apply(Class<? extends RuleExtender> input) {
                try {
                    return input.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new IllegalStateException("Could not instantiate RuleExtender", e);
                }
            }
        }));
        for (RuleExtender ruleExtender : extenderInstances) {
            ruleExtender.setup(testDescription);
        }
        return new Extenders(extenderInstances);
    }

    static Extenders createFromKnownSetWithDescription(Set<? extends RuleExtender> extenders, Description description) {
        for (RuleExtender ruleExtender : extenders) {
            ruleExtender.setup(description);
        }
        return new Extenders(extenders);
    }

    private static Set<Class<? extends RuleExtender>> findRuleExtenderClasses() {
        return new Reflections(RuleExtender.class.getPackage().getName(), new Scanner[0]).getSubTypesOf(RuleExtender.class);
    }

    @Override
    public void close() {
        for (RuleExtender ruleExtender : this.extenders) {
            ruleExtender.close();
        }
    }
}

