/*
 * Decompiled with CFR 0.152.
 */
package org.constretto.test.extractors;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.constretto.exception.ConstrettoException;
import org.constretto.test.extractors.TagExtractor;
import org.junit.runner.Description;

public class ConstrettoEnvironmentExtractor
implements TagExtractor {
    @Override
    public String[] findTagsForTest(Description testDescription) {
        Class<? extends Annotation> environmentAnnotationType = this.environmentAnnotation();
        Annotation envAnnotation = testDescription.getTestClass().getAnnotation(environmentAnnotationType);
        if (envAnnotation == null) {
            return null;
        }
        try {
            Method valueMethod = envAnnotation.getClass().getMethod("value", new Class[0]);
            return (String[])valueMethod.invoke((Object)envAnnotation, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new ConstrettoException("Could not extract environment from test class", (Throwable)e);
        }
    }

    private Class<? extends Annotation> environmentAnnotation() {
        try {
            return Class.forName("org.constretto.spring.annotation.Environment");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static String[] extractEnvironmentValue(Description description) {
        return new ConstrettoEnvironmentExtractor().findTagsForTest(description);
    }
}

