/*
 * Decompiled with CFR 0.152.
 */
package org.constretto.test.extender;

import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import java.util.stream.Collectors;
import org.constretto.test.extender.RuleExtender;
import org.junit.runner.Description;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class Extenders
implements AutoCloseable {
    private Set<? extends RuleExtender> extenders;

    public Extenders(Set<? extends RuleExtender> extenders) {
        this.extenders = extenders;
    }

    static Extenders createFromClasspathUsingDescription(Description testDescription) {
        Set<RuleExtender> extenders = Extenders.findRuleExtenderClasses().stream().filter(aClass -> {
            try {
                return aClass.getDeclaredConstructor(new Class[0]) != null;
            }
            catch (NoSuchMethodException e) {
                return false;
            }
        }).map(aClass -> {
            try {
                return (RuleExtender)aClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new IllegalStateException("Could not invoke default constructor on RuleExtender", e);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Could not instantiate RuleExtender", e);
            }
        }).collect(Collectors.toSet());
        extenders.forEach(ruleExtender -> ruleExtender.setup(testDescription));
        return new Extenders(extenders);
    }

    static Extenders createFromKnownSetWithDescription(Set<? extends RuleExtender> extenders, Description description) {
        for (RuleExtender ruleExtender : extenders) {
            ruleExtender.setup(description);
        }
        return new Extenders(extenders);
    }

    private static Set<Class<? extends RuleExtender>> findRuleExtenderClasses() {
        return new Reflections(RuleExtender.class.getPackage().getName(), new Scanner[0]).getSubTypesOf(RuleExtender.class);
    }

    @Override
    public void close() {
        for (RuleExtender ruleExtender : this.extenders) {
            ruleExtender.close();
        }
    }
}

