/*
 * Decompiled with CFR 0.152.
 */
package org.cooder.units;

import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.format.MeasurementParseException;
import org.cooder.units.Units;
import tech.units.indriya.quantity.Quantities;

public final class UnitNumber<Q extends Quantity<Q>> {
    private final Quantity<Q> q;

    public UnitNumber(Number value, Unit<Q> unit) {
        this.q = Quantities.getQuantity((Number)value, unit);
    }

    private UnitNumber(Quantity<Q> q) {
        this(q.getValue(), q.getUnit());
    }

    public Number getValue() {
        return this.q.getValue();
    }

    public Unit<Q> getUnit() {
        return this.q.getUnit();
    }

    public UnitNumber<Q> add(UnitNumber<Q> addend) {
        Quantity res = this.q.add(addend.q);
        return UnitNumber.cast(res);
    }

    public UnitNumber<Q> subtract(UnitNumber<Q> subtrahend) {
        Quantity res = this.q.subtract(subtrahend.q);
        return UnitNumber.cast(res);
    }

    public UnitNumber<Q> multiply(Number multiplicand) {
        Quantity res = this.q.multiply(multiplicand);
        return UnitNumber.cast(res);
    }

    public UnitNumber<?> multiply(UnitNumber<?> multiplicand) {
        Quantity res = this.q.toSystemUnit().multiply(multiplicand.q.toSystemUnit());
        return UnitNumber.cast(res);
    }

    public UnitNumber<Q> divide(Number divisor) {
        Quantity res = this.q.divide(divisor);
        return UnitNumber.cast(res);
    }

    public UnitNumber<?> divide(UnitNumber<?> divisor) {
        Quantity res = this.q.toSystemUnit().divide(divisor.q.toSystemUnit());
        return UnitNumber.cast(res);
    }

    public UnitNumber<?> inverse() {
        Quantity res = this.q.inverse();
        return UnitNumber.cast(res);
    }

    public UnitNumber<Q> negate() {
        Quantity res = this.q.negate();
        return UnitNumber.cast(res);
    }

    public UnitNumber<Q> to(Unit<Q> unit) {
        Quantity res = this.q.to(unit);
        return UnitNumber.cast(res);
    }

    public UnitNumber<Q> toSystemUnit() {
        return this.to(this.getUnit().getSystemUnit());
    }

    public boolean isEquivalentTo(UnitNumber<Q> that) {
        return this.q.isEquivalentTo(that.q);
    }

    public <T extends Quantity<T>> UnitNumber<T> asType(Class<T> type) throws ClassCastException {
        Quantity res = this.q.asType(type);
        return UnitNumber.cast(res);
    }

    public UnitNumber<Q> assertMustBe(Unit<?> that) {
        if (!this.q.getUnit().toString().equals(that.toString())) {
            String msg = String.format("[%s] is illegal", this.q.getUnit());
            throw new IllegalStateException(msg);
        }
        return this;
    }

    public UnitNumber<Q> assertIncludedInUnits() {
        Unit<?> u = Units.getUnit(this.q.getUnit().toString());
        if (u == null) {
            String msg = String.format("[%s] is illegal", this.q.getUnit());
            throw new IllegalStateException(msg);
        }
        return this;
    }

    public String toString() {
        return this.q.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof UnitNumber) {
            return this.q.equals(((UnitNumber)obj).q);
        }
        return false;
    }

    public int hashCode() {
        return this.q.hashCode();
    }

    public static UnitNumber<?> parse(CharSequence cs) {
        try {
            Quantity q = Quantities.getQuantity((CharSequence)cs);
            return UnitNumber.cast(q);
        }
        catch (MeasurementParseException e) {
            throw new IllegalArgumentException(e.getParsedString(), e);
        }
    }

    private static <T extends Quantity<T>> UnitNumber<T> cast(Quantity<T> q) {
        return new UnitNumber<T>(q);
    }
}

