/*
 * Decompiled with CFR 0.152.
 */
package org.cooder.units;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Area;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.Length;
import javax.measure.quantity.Mass;
import javax.measure.quantity.Temperature;
import javax.measure.quantity.Time;
import javax.measure.quantity.Volume;
import org.cooder.units.quantity.Money;
import org.cooder.units.quantity.SKU;
import org.cooder.units.quantity.WorkTime;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.format.SimpleQuantityFormat;
import tech.units.indriya.format.SimpleUnitFormat;
import tech.units.indriya.function.AbstractConverter;
import tech.units.indriya.function.AddConverter;
import tech.units.indriya.function.MultiplyConverter;
import tech.units.indriya.unit.AlternateUnit;
import tech.units.indriya.unit.TransformedUnit;

public final class Units {
    private static final tech.units.indriya.unit.Units BASIC_UNITS = tech.units.indriya.unit.Units.getInstance();
    private static final Set<Unit<?>> ALL_UNITS = new HashSet();
    private static final Map<String, Unit<?>> SYMBOL_MAP = new HashMap();
    private static final Map<String, Unit<?>> NAME_MAP = new HashMap();
    public static final Unit<Dimensionless> \u5355\u4f4d\u4e00 = AbstractUnit.ONE;
    public static final Unit<Dimensionless> ONE = AbstractUnit.ONE;
    public static final Unit<Length> \u7c73 = Units.addUnit(tech.units.indriya.unit.Units.METRE, "\u7c73");
    public static final Unit<Length> \u5ef6\u7c73 = Units.addUnit(AlternateUnit.of((Unit)tech.units.indriya.unit.Units.METRE, (String)"\u5ef6\u7c73"), "\u5ef6\u7c73");
    public static final Unit<Length> \u5398\u7c73 = Units.addUnit(new TransformedUnit("cm", tech.units.indriya.unit.Units.METRE.divide(100.0), (UnitConverter)AbstractConverter.IDENTITY), "\u5398\u7c73");
    public static final Unit<Length> \u6beb\u7c73 = Units.addUnit(new TransformedUnit("mm", tech.units.indriya.unit.Units.METRE.divide(1000.0), (UnitConverter)AbstractConverter.IDENTITY), "\u6beb\u7c73");
    public static final Unit<Area> \u5e73\u65b9\u7c73 = Units.addUnit(new TransformedUnit("m\u00b2", "\u5e73\u7c73", tech.units.indriya.unit.Units.SQUARE_METRE, (UnitConverter)AbstractConverter.IDENTITY), "\u5e73\u7c73");
    public static final Unit<Area> \u5e73\u65b9\u5398\u7c73 = Units.addUnit(new TransformedUnit("cm\u00b2", tech.units.indriya.unit.Units.SQUARE_METRE.divide(10000.0), (UnitConverter)AbstractConverter.IDENTITY), "\u5e73\u65b9\u5398\u7c73");
    public static final Unit<Area> \u5e73\u65b9\u6beb\u7c73 = Units.addUnit(new TransformedUnit("mm\u00b2", tech.units.indriya.unit.Units.SQUARE_METRE.divide(1000000.0), (UnitConverter)AbstractConverter.IDENTITY), "\u5e73\u65b9\u6beb\u7c73");
    public static final Unit<Volume> \u7acb\u65b9\u7c73 = Units.addUnit(new TransformedUnit("m\u00b3", "\u7acb\u65b9\u7c73", tech.units.indriya.unit.Units.CUBIC_METRE, (UnitConverter)AbstractConverter.IDENTITY), "\u7acb\u65b9\u7c73");
    public static final Unit<Volume> \u7acb\u65b9\u5398\u7c73 = Units.addUnit(new TransformedUnit("cm\u00b3", tech.units.indriya.unit.Units.CUBIC_METRE.divide(1000000.0), (UnitConverter)AbstractConverter.IDENTITY), "\u7acb\u65b9\u5398\u7c73");
    public static final Unit<Volume> \u7acb\u65b9\u6beb\u7c73 = Units.addUnit(new TransformedUnit("mm\u00b3", tech.units.indriya.unit.Units.CUBIC_METRE.divide(1.0E9), (UnitConverter)AbstractConverter.IDENTITY), "\u7acb\u65b9\u6beb\u7c73");
    public static final Unit<Volume> \u5347 = Units.addUnit(tech.units.indriya.unit.Units.LITRE, "\u5347");
    public static final Unit<Volume> \u6beb\u5347 = Units.addUnit(new TransformedUnit("ml", tech.units.indriya.unit.Units.LITRE.divide(1000.0), (UnitConverter)AbstractConverter.IDENTITY), "\u6beb\u5347");
    public static final Unit<Mass> \u5343\u514b = Units.addUnit(tech.units.indriya.unit.Units.KILOGRAM, "\u5343\u514b");
    public static final Unit<Mass> \u514b = Units.addUnit(new TransformedUnit("g", tech.units.indriya.unit.Units.KILOGRAM.divide(1000.0), (UnitConverter)AbstractConverter.IDENTITY), "\u514b");
    public static final Unit<Temperature> \u6444\u6c0f\u5ea6 = Units.addUnit(new TransformedUnit("\u2103", tech.units.indriya.unit.Units.KELVIN, (UnitConverter)new AddConverter((Number)273.15)), "\u6444\u6c0f\u5ea6");
    public static final Unit<Angle> \u89d2\u5ea6 = Units.addUnit(new TransformedUnit("\u00b0", tech.units.indriya.unit.Units.RADIAN, MultiplyConverter.ofPiExponent((int)1).concatenate((UnitConverter)MultiplyConverter.ofRational((long)1L, (long)180L))), "\u89d2\u5ea6");
    public static final Unit<Time> \u79d2 = Units.addUnit(tech.units.indriya.unit.Units.SECOND, "\u79d2\u949f");
    public static final Unit<Time> \u5206 = Units.addUnit(new TransformedUnit("min", tech.units.indriya.unit.Units.SECOND.multiply(60.0), (UnitConverter)AbstractConverter.IDENTITY), "\u5206\u949f");
    public static final Unit<Time> \u5c0f\u65f6 = Units.addUnit(new TransformedUnit("hour", tech.units.indriya.unit.Units.SECOND.multiply(3600.0), (UnitConverter)AbstractConverter.IDENTITY), "\u5c0f\u65f6");
    public static final Unit<Time> \u5929 = Units.addUnit(new TransformedUnit("day", tech.units.indriya.unit.Units.SECOND.multiply(86400.0), (UnitConverter)AbstractConverter.IDENTITY), "\u5929");
    public static final Unit<Dimensionless> \u4eba = Units.addUnit(AlternateUnit.of(ONE, (String)"man"), "\u4eba");
    public static final Unit<WorkTime> \u4eba\u65f6 = Units.addUnit(new TransformedUnit("\u4eba\u65f6", \u4eba.multiply(\u5c0f\u65f6), (UnitConverter)AbstractConverter.IDENTITY).asType(WorkTime.class), "\u4eba\u65f6");
    public static final Unit<WorkTime> \u4eba\u5929 = Units.addUnit(new TransformedUnit("\u4eba\u5929", \u4eba\u65f6.multiply(8.0), (UnitConverter)AbstractConverter.IDENTITY), "\u4eba\u5929");
    public static final Unit<Money> \u5143 = Units.addUnit(AlternateUnit.of(ONE, (String)"\u5143").asType(Money.class), "\u5143");
    public static final Unit<Money> \u4e07\u5143 = Units.addUnit(new TransformedUnit("\u4e07\u5143", \u5143.multiply(10000.0), (UnitConverter)AbstractConverter.IDENTITY).asType(Money.class), "\u4e07\u5143");
    public static final Unit<Dimensionless> \u672a\u77e5 = Units.addUnit(AlternateUnit.of(ONE, (String)"\u672a\u77e5"), "\u672a\u77e5");
    private static final String[] SKU_UNITS_NAMES;

    public static void init() {
    }

    public static Unit<?> symbolFor(String symbol) {
        if (!Units.notEmpty(symbol)) {
            return ONE;
        }
        Unit<?> u = SYMBOL_MAP.get(symbol);
        if (u == null) {
            u = Units.getUnit(BASIC_UNITS.getUnits(), symbol);
        }
        return u;
    }

    public static Unit<?> nameFor(String name) {
        return NAME_MAP.get(name);
    }

    public static Unit<?> parse(String symbol) {
        String e = String.format("0 %s", symbol);
        return SimpleQuantityFormat.getInstance((String)"n u").parse((CharSequence)e).getUnit();
    }

    static Unit<?> getUnit(String string) {
        Unit<?> u = Units.getUnit(ALL_UNITS, string);
        if (u == null) {
            u = Units.getUnit(BASIC_UNITS.getUnits(), string);
        }
        return u;
    }

    public static <U extends Unit<?>> U addAlias(U unit, String alias) {
        if (!ALL_UNITS.contains(unit)) {
            throw new IllegalArgumentException("unit not exist.");
        }
        if (Units.notEmpty(alias)) {
            Unit<?> pre = NAME_MAP.putIfAbsent(alias, unit);
            Units.requireNull(pre);
            SimpleUnitFormat.getInstance().alias(unit, alias);
        }
        return unit;
    }

    public static <U extends Unit<?>> U addUnit(U unit, String alias) {
        Unit<?> pre;
        ALL_UNITS.add(unit);
        if (Units.notEmpty(unit.getSymbol())) {
            pre = SYMBOL_MAP.putIfAbsent(unit.getSymbol(), unit);
            Units.requireNull(pre);
            SimpleUnitFormat.getInstance().label(unit, unit.getSymbol());
        }
        if (Units.notEmpty(alias)) {
            pre = NAME_MAP.putIfAbsent(alias, unit);
            Units.requireNull(pre);
            SimpleUnitFormat.getInstance().alias(unit, alias);
        }
        return unit;
    }

    public static Unit<SKU> addSkuUnit(String symbol, String name) {
        return Units.addUnit(AlternateUnit.of(ONE, (String)symbol).asType(SKU.class), name);
    }

    private static void requireNull(Unit<?> pre) {
        if (pre != null) {
            String msg = String.format("[%s] duplicated", pre);
            throw new IllegalStateException(msg);
        }
    }

    private static Unit<?> getUnit(Collection<Unit<?>> units, String string) {
        Objects.requireNonNull(string);
        return units.stream().filter(u -> string.equals(u.toString())).findAny().orElse(null);
    }

    private static boolean notEmpty(String str) {
        return str != null && str.length() > 0;
    }

    static {
        for (String s : SKU_UNITS_NAMES = new String[]{"\u6839", "\u7247", "\u6761", "\u888b", "\u6846", "\u5957", "\u6a18", "\u4e2a", "\u53f0", "\u4ef6", "\u53ea", "\u9879", "\u6247", "\u5377", "\u6876", "\u76d2", "\u5f20", "\u6346", "\u628a", "\u67b6", "\u5757", "\u74f6", "\u652f", "\u7bb1", "\u4ed8", "\u5bf9", "\u6b21"}) {
            Units.addSkuUnit(s, s);
        }
    }
}

