/*
 * Decompiled with CFR 0.152.
 */
package org.cooder.units;

import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.format.MeasurementParseException;
import javax.measure.quantity.Dimensionless;
import org.cooder.units.Units;
import org.cooder.units.quantity.UNKNOWN;
import tech.units.indriya.function.Calculus;
import tech.units.indriya.quantity.Quantities;
import tech.units.indriya.unit.ProductUnit;

public final class UnitNumber<Q extends Quantity<Q>> {
    public static final UnitNumber<?> UNKNOWN_NUMBER = new UnitNumber<Dimensionless>(1, Units.\u672a\u77e5);
    private final Quantity<Q> q;

    public UnitNumber(Number value, Unit<Q> unit) {
        this.q = Quantities.getQuantity((Number)value, unit);
    }

    private UnitNumber(Quantity<Q> q) {
        this(q.getValue(), q.getUnit());
    }

    public Number getValue() {
        return this.q.getValue();
    }

    public Unit<Q> getUnit() {
        return this.q.getUnit();
    }

    public UnitNumber<Q> add(UnitNumber<Q> addend) {
        this.checkDimensionless(addend.getUnit());
        Quantity res = this.q.add(addend.q);
        return UnitNumber.cast(res);
    }

    public UnitNumber<Q> subtract(UnitNumber<Q> subtrahend) {
        this.checkDimensionless(subtrahend.getUnit());
        Quantity res = this.q.subtract(subtrahend.q);
        return UnitNumber.cast(res);
    }

    public UnitNumber<Q> multiply(Number multiplicand) {
        Quantity res = this.q.multiply(multiplicand);
        return UnitNumber.cast(res);
    }

    public UnitNumber<?> multiply(UnitNumber<?> multiplicand) {
        Quantity res = this.q.toSystemUnit().multiply(multiplicand.q.toSystemUnit());
        return UnitNumber.cast(res);
    }

    public UnitNumber<Q> divide(Number divisor) {
        Quantity res = this.q.divide(divisor);
        return UnitNumber.cast(res);
    }

    public UnitNumber<?> divide(UnitNumber<?> divisor) {
        Quantity res = this.q.toSystemUnit().divide(divisor.q.toSystemUnit());
        return UnitNumber.cast(res);
    }

    public UnitNumber<?> inverse() {
        Quantity res = this.q.inverse();
        return UnitNumber.cast(res);
    }

    public UnitNumber<Q> negate() {
        Quantity res = this.q.negate();
        return UnitNumber.cast(res);
    }

    public UnitNumber<Q> to(Unit<Q> unit) {
        this.checkDimensionless(unit);
        Quantity res = this.q.to(unit);
        return UnitNumber.cast(res);
    }

    public UnitNumber<Q> toSystemUnit() {
        return this.to(this.getUnit().getSystemUnit());
    }

    public boolean isEquivalentTo(UnitNumber<Q> that) {
        this.checkDimensionless(that.getUnit());
        return this.q.isEquivalentTo(that.q);
    }

    public int compareTo(UnitNumber<Q> that) {
        this.checkDimensionless(that.getUnit());
        return Calculus.currentNumberSystem().compare(this.getValue(), that.to(this.getUnit()).getValue());
    }

    public <T extends Quantity<T>> UnitNumber<T> asType(Class<T> type) throws ClassCastException {
        Quantity res = this.q.asType(type);
        return UnitNumber.cast(res);
    }

    public UnitNumber<Q> assertMustBe(Unit<?> that) {
        Unit u = this.q.getUnit();
        if (!u.isCompatible(that) || !u.toString().equals(that.toString())) {
            throw UnitNumber.unitNotMatch(u, that);
        }
        return this;
    }

    public UnitNumber<Q> assertIncludedInUnits() {
        Unit<?> u = Units.getUnit(this.q.getUnit().toString());
        if (u == null) {
            String msg = String.format("[%s] is illegal", this.q.getUnit());
            throw new IllegalStateException(msg);
        }
        return this;
    }

    public String toString() {
        return this.q.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof UnitNumber) {
            return this.q.equals(((UnitNumber)obj).q);
        }
        return false;
    }

    public int hashCode() {
        return this.q.hashCode();
    }

    private void checkDimensionless(Unit<Q> that) {
        Unit u = this.q.getUnit();
        if (this.q.getUnit().isCompatible(Units.ONE)) {
            this.assertMustBe(that);
        }
        if (that instanceof ProductUnit && u instanceof ProductUnit) {
            ProductUnit pu1 = (ProductUnit)u;
            ProductUnit pu2 = (ProductUnit)that;
            if (pu1.getUnitCount() != pu2.getUnitCount()) {
                String msg = String.format("[%s] is not [%s]", u, that);
                throw new IllegalStateException(msg);
            }
            for (int i = 0; i < pu1.getUnitCount(); ++i) {
                Unit u1 = pu1.getUnit(i);
                Unit u2 = pu2.getUnit(i);
                if (!u1.isCompatible(Units.ONE)) continue;
                UnitNumber.assertMustEq(u1, u2);
            }
        } else if (that instanceof ProductUnit || u instanceof ProductUnit) {
            UnitNumber.assertMustEq(u, that);
        }
    }

    public static UnitNumber<?> parse(CharSequence cs) {
        try {
            Quantity q = Quantities.getQuantity((CharSequence)cs);
            return UnitNumber.cast(q);
        }
        catch (MeasurementParseException e) {
            throw new IllegalArgumentException(e.getParsedString(), e);
        }
    }

    public static UnitNumber<?> add(UnitNumber<?> number1, UnitNumber<?> number2) {
        return number1.asType(UNKNOWN.class).add(number2.asType(UNKNOWN.class));
    }

    public static UnitNumber<?> subtract(UnitNumber<?> number1, UnitNumber<?> number2) {
        return number1.asType(UNKNOWN.class).subtract(number2.asType(UNKNOWN.class));
    }

    public static UnitNumber<?> to(UnitNumber<?> number1, Unit<?> unit) {
        return number1.asType(UNKNOWN.class).to((Unit<UNKNOWN>)unit.asType(UNKNOWN.class));
    }

    public static int compare(UnitNumber<?> x, UnitNumber<?> y) {
        UnitNumber<UNKNOWN> n1 = x.asType(UNKNOWN.class);
        UnitNumber<UNKNOWN> n2 = y.asType(UNKNOWN.class);
        return Calculus.currentNumberSystem().compare(n1.to(n2.getUnit()).getValue(), n2.getValue());
    }

    private static <T extends Quantity<T>> UnitNumber<T> cast(Quantity<T> q) {
        return new UnitNumber<T>(q);
    }

    private static void assertMustEq(Unit<?> u, Unit<?> that) {
        if (!u.isCompatible(that) || !u.toString().equals(that.toString())) {
            throw UnitNumber.unitNotMatch(u, that);
        }
    }

    private static IllegalStateException unitNotMatch(Unit<?> u, Unit<?> that) {
        String msg = String.format("[%s] is not [%s]", u, that);
        return new IllegalStateException(msg);
    }
}

