/*
 * Decompiled with CFR 0.152.
 */
package org.cooder.jooq.mate;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Modifier;
import org.cooder.jooq.mate.FieldMeta;
import org.cooder.jooq.mate.Generator;
import org.cooder.jooq.mate.TableMeta;
import org.cooder.jooq.mate.TypeGeneratorStrategy;
import org.jooq.tools.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

class ApiGenerator
implements Generator {
    private TypeGeneratorStrategy strategy;

    public ApiGenerator(TypeGeneratorStrategy strategy) {
        this.strategy = strategy;
    }

    public static ApiGenerator of(TypeGeneratorStrategy strategy) {
        return new ApiGenerator(strategy);
    }

    @Override
    public void generate(TableMeta table) {
        this.generateRestController(table);
    }

    private void generateRestController(TableMeta table) {
        if (!this.strategy.isRootTable(table)) {
            return;
        }
        String tableName = table.getName();
        ClassName className = this.strategy.controllerClassName(tableName);
        TypeSpec.Builder ts = TypeSpec.classBuilder((String)className.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(RestController.class);
        String serviceClazzNameLC = StringUtils.toLC((String)this.strategy.serviceClazzName(tableName));
        ts.addField(FieldSpec.builder((TypeName)this.strategy.serviceClassName(tableName), (String)serviceClazzNameLC, (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(Autowired.class).build());
        this.generateCreater(ts, table);
        this.generateUpdater(ts, table);
        if (table.hasUniqKey()) {
            this.generateFlatGetter(ts, table);
        } else {
            this.generateGetter(ts, table);
        }
        this.generateLister(ts, table);
        this.output(this.strategy.getIndent(), this.strategy.getApiDirectory(), this.strategy.apiPackageName(tableName), ts.build());
    }

    private void generateCreater(TypeSpec.Builder ts, TableMeta table) {
        String serviceClazzNameLC = StringUtils.toLC((String)this.strategy.serviceClazzName(table.getName()));
        MethodSpec.Builder b = this.generateMethod(table, "create");
        b.returns(Void.TYPE);
        b.addCode(CodeBlock.builder().addStatement("$L.$L(entity)", new Object[]{serviceClazzNameLC, b.build().name}).build());
        ts.addMethod(b.build());
    }

    private void generateUpdater(TypeSpec.Builder ts, TableMeta table) {
        String serviceClazzNameLC = StringUtils.toLC((String)this.strategy.serviceClazzName(table.getName()));
        MethodSpec.Builder b = this.generateMethod(table, "update");
        b.returns(Void.TYPE);
        b.addCode(CodeBlock.builder().addStatement("$L.$L(entity)", new Object[]{serviceClazzNameLC, b.build().name}).build());
        ts.addMethod(b.build());
    }

    private void generateGetter(TypeSpec.Builder ts, TableMeta table) {
        String serviceClazzNameLC = StringUtils.toLC((String)this.strategy.serviceClazzName(table.getName()));
        String tableName = table.getName();
        ClassName pojoCN = this.strategy.pojoClassName(tableName);
        MethodSpec.Builder b = this.generateMethod(table, "get");
        b.returns((TypeName)pojoCN);
        b.addCode(CodeBlock.builder().addStatement("return $L.$L(entity)", new Object[]{serviceClazzNameLC, b.build().name}).build());
        ts.addMethod(b.build());
    }

    private void generateFlatGetter(TypeSpec.Builder ts, TableMeta table) {
        String serviceClazzNameLC = StringUtils.toLC((String)this.strategy.serviceClazzName(table.getName()));
        String tableName = table.getName();
        ClassName intrCN = this.strategy.interfaceClassName(tableName);
        ClassName pojoCN = this.strategy.pojoClassName(tableName);
        String path = String.format("/api/%s/info", intrCN.simpleName());
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)("get" + intrCN.simpleName())).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(PostMapping.class).addMember("value", "$S", new Object[]{path}).build());
        ArrayList<String> paramrers = new ArrayList<String>();
        for (FieldMeta f : table.fields()) {
            if (!f.isUniqKey()) continue;
            ParameterSpec p = ParameterSpec.builder(f.getType(), (String)StringUtils.toCamelCaseLC((String)f.getName()), (Modifier[])new Modifier[0]).addAnnotation(RequestParam.class).build();
            b.addParameter(p);
            paramrers.add(StringUtils.toCamelCaseLC((String)f.getName()));
        }
        b.returns((TypeName)pojoCN);
        b.addCode(CodeBlock.builder().addStatement("return $L.$L($L)", new Object[]{serviceClazzNameLC, b.build().name, StringUtils.join((Object[])paramrers.toArray(new String[0]), (String)", ")}).build());
        ts.addMethod(b.build());
    }

    private void generateLister(TypeSpec.Builder ts, TableMeta table) {
        String serviceClazzNameLC = StringUtils.toLC((String)this.strategy.serviceClazzName(table.getName()));
        String tableName = table.getName();
        ClassName pojoCN = this.strategy.pojoClassName(tableName);
        MethodSpec.Builder b = this.generateMethod(table, "list");
        b.returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{pojoCN}));
        b.addCode(CodeBlock.builder().addStatement("return $L.$L(entity)", new Object[]{serviceClazzNameLC, b.build().name}).build());
        ts.addMethod(b.build());
    }

    private MethodSpec.Builder generateMethod(TableMeta table, String type) {
        String tableName = table.getName();
        ClassName intrCN = this.strategy.interfaceClassName(tableName);
        ClassName pojoCN = this.strategy.pojoClassName(tableName);
        String path = String.format("/api/%s/%s", intrCN.simpleName(), type);
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)(type + intrCN.simpleName())).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(PostMapping.class).addMember("value", "$S", new Object[]{path}).build()).addParameter(ParameterSpec.builder((TypeName)pojoCN, (String)"entity", (Modifier[])new Modifier[0]).addAnnotation(RequestBody.class).build());
        return b;
    }
}

