/*
 * Decompiled with CFR 0.152.
 */
package org.cooder.jooq.mate;

import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.read.metadata.holder.ReadRowHolder;
import com.alibaba.excel.util.StringUtils;
import com.google.common.graph.MutableValueGraph;
import com.google.common.graph.ValueGraphBuilder;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.cooder.jooq.mate.MateUtils;
import org.cooder.jooq.mate.utils.TypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class ConfigurationParser {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationParser.class);

    public Config parse(String file) {
        Config config = new Config();
        this.parseJooqConfig(file, config.jooqConfig());
        this.parseJooqMateConfig(file, config.mateConfig());
        this.parseTableConfigs(file, config);
        return config;
    }

    private void parseTableConfigs(String file, Config config) {
        TableConfigListenerImpl listener = new TableConfigListenerImpl();
        ExcelReader reader = EasyExcelFactory.read((String)file, TableConfig.Header.class, (ReadListener)listener).build();
        List sheets = reader.excelExecutor().sheetList();
        for (ReadSheet sheet : sheets) {
            listener.reset();
            if (!sheet.getSheetName().toLowerCase().startsWith("table")) continue;
            log.info("process table config: ", (Object)sheet.getSheetName());
            reader.read(new ReadSheet[]{sheet});
            config.addTable(listener.getTableConfig());
        }
    }

    private void parseJooqConfig(String file, JooqConfig config) {
        SingleTableListenerImpl listener = new SingleTableListenerImpl();
        ExcelReader reader = EasyExcelFactory.read((String)file, listener).build();
        ReadSheet sheet = ((ExcelReaderSheetBuilder)EasyExcelFactory.readSheet((String)"jooq-codegen-config").head(JooqConfig.Header.class)).build();
        reader.read(new ReadSheet[]{sheet});
        listener.getDatas().forEach(v -> {
            if (v.getConfigValue() == null) {
                return;
            }
            Object value = ConfigurationParser.cast(v.getConfigName(), v.getConfigValue(), config.getClass());
            if (value != null) {
                TypeUtils.setValue((Object)config, (String)v.getConfigName(), (Object)value);
            }
        });
    }

    private void parseJooqMateConfig(String file, JooqMateConfig config) {
        SingleTableListenerImpl listener = new SingleTableListenerImpl();
        ExcelReader reader = EasyExcelFactory.read((String)file, listener).build();
        ReadSheet sheet = ((ExcelReaderSheetBuilder)EasyExcelFactory.readSheet((String)"jooq-mate-config").head(JooqMateConfig.Header.class)).build();
        reader.read(new ReadSheet[]{sheet});
        listener.getDatas().forEach(v -> {
            if (v.getConfigValue() == null) {
                return;
            }
            Object value = ConfigurationParser.cast(v.getConfigName(), v.getConfigValue(), config.getClass());
            if (value != null) {
                TypeUtils.setValue((Object)config, (String)v.getConfigName(), (Object)value);
            }
        });
    }

    static Object cast(String name, Object value, Class<?> to) {
        PropertyDescriptor pd = BeanUtils.getPropertyDescriptor(to, (String)name);
        if (value == null || pd == null) {
            return null;
        }
        Class<?> pt = pd.getPropertyType();
        if (pt == Boolean.TYPE || pt == Boolean.class) {
            value = Boolean.valueOf((String)value);
        } else if (pt == String[].class) {
            value = MateUtils.split(value.toString(), ",");
        } else if (pt == Integer.TYPE || pt == Integer.class) {
            value = Integer.valueOf(value.toString());
        } else if (pt == TableConfig.UniqKey.class) {
            value = new TableConfig.UniqKey();
        }
        return value;
    }

    public static class TableConfig {
        private String tableName;
        private String tableNameDesc;
        private String tableDesc;
        private String primaryKey;
        private UniqKey uniqueKey;
        private String engine;
        private String autoIncrement;
        private String defaultCharset;
        private int shardingCount;
        private String parentTableName;
        private String jooqDaoClass;
        private String jooqPojoClass;
        private String jooqPojoImplements;
        private String jooqmateSubpackage = "";
        private String[] jooqmateIgnoreFieldNames = new String[0];
        private String jooqmateInterfaceName;
        private String[] jooqmateInterfaceSupers = new String[0];
        private String jooqmateRecordName;
        private String jooqmatePojoName;
        private String jooqmatePojoSuperClass;
        private String jooqmatePojoImplements;
        private List<FieldConfig> fields = new ArrayList<FieldConfig>();

        public TableConfig addField(FieldConfig c) {
            this.fields.add(c);
            if (this.isUniqKeyPart(c.getFieldName())) {
                c.setUniqKey(true);
            }
            return this;
        }

        public boolean isUniqKeyPart(String fieldName) {
            return this.uniqueKey != null && this.uniqueKey.contains(fieldName);
        }

        public String getTableName() {
            return this.tableName;
        }

        public String getTableNameDesc() {
            return this.tableNameDesc;
        }

        public String getTableDesc() {
            return this.tableDesc;
        }

        public String getPrimaryKey() {
            return this.primaryKey;
        }

        public UniqKey getUniqueKey() {
            return this.uniqueKey;
        }

        public String getEngine() {
            return this.engine;
        }

        public String getAutoIncrement() {
            return this.autoIncrement;
        }

        public String getDefaultCharset() {
            return this.defaultCharset;
        }

        public int getShardingCount() {
            return this.shardingCount;
        }

        public String getParentTableName() {
            return this.parentTableName;
        }

        public String getJooqDaoClass() {
            return this.jooqDaoClass;
        }

        public String getJooqPojoClass() {
            return this.jooqPojoClass;
        }

        public String getJooqPojoImplements() {
            return this.jooqPojoImplements;
        }

        public String getJooqmateSubpackage() {
            return this.jooqmateSubpackage;
        }

        public String[] getJooqmateIgnoreFieldNames() {
            return this.jooqmateIgnoreFieldNames;
        }

        public String getJooqmateInterfaceName() {
            return this.jooqmateInterfaceName;
        }

        public String[] getJooqmateInterfaceSupers() {
            return this.jooqmateInterfaceSupers;
        }

        public String getJooqmateRecordName() {
            return this.jooqmateRecordName;
        }

        public String getJooqmatePojoName() {
            return this.jooqmatePojoName;
        }

        public String getJooqmatePojoSuperClass() {
            return this.jooqmatePojoSuperClass;
        }

        public String getJooqmatePojoImplements() {
            return this.jooqmatePojoImplements;
        }

        public List<FieldConfig> getFields() {
            return this.fields;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public void setTableNameDesc(String tableNameDesc) {
            this.tableNameDesc = tableNameDesc;
        }

        public void setTableDesc(String tableDesc) {
            this.tableDesc = tableDesc;
        }

        public void setPrimaryKey(String primaryKey) {
            this.primaryKey = primaryKey;
        }

        public void setUniqueKey(UniqKey uniqueKey) {
            this.uniqueKey = uniqueKey;
        }

        public void setEngine(String engine) {
            this.engine = engine;
        }

        public void setAutoIncrement(String autoIncrement) {
            this.autoIncrement = autoIncrement;
        }

        public void setDefaultCharset(String defaultCharset) {
            this.defaultCharset = defaultCharset;
        }

        public void setShardingCount(int shardingCount) {
            this.shardingCount = shardingCount;
        }

        public void setParentTableName(String parentTableName) {
            this.parentTableName = parentTableName;
        }

        public void setJooqDaoClass(String jooqDaoClass) {
            this.jooqDaoClass = jooqDaoClass;
        }

        public void setJooqPojoClass(String jooqPojoClass) {
            this.jooqPojoClass = jooqPojoClass;
        }

        public void setJooqPojoImplements(String jooqPojoImplements) {
            this.jooqPojoImplements = jooqPojoImplements;
        }

        public void setJooqmateSubpackage(String jooqmateSubpackage) {
            this.jooqmateSubpackage = jooqmateSubpackage;
        }

        public void setJooqmateIgnoreFieldNames(String[] jooqmateIgnoreFieldNames) {
            this.jooqmateIgnoreFieldNames = jooqmateIgnoreFieldNames;
        }

        public void setJooqmateInterfaceName(String jooqmateInterfaceName) {
            this.jooqmateInterfaceName = jooqmateInterfaceName;
        }

        public void setJooqmateInterfaceSupers(String[] jooqmateInterfaceSupers) {
            this.jooqmateInterfaceSupers = jooqmateInterfaceSupers;
        }

        public void setJooqmateRecordName(String jooqmateRecordName) {
            this.jooqmateRecordName = jooqmateRecordName;
        }

        public void setJooqmatePojoName(String jooqmatePojoName) {
            this.jooqmatePojoName = jooqmatePojoName;
        }

        public void setJooqmatePojoSuperClass(String jooqmatePojoSuperClass) {
            this.jooqmatePojoSuperClass = jooqmatePojoSuperClass;
        }

        public void setJooqmatePojoImplements(String jooqmatePojoImplements) {
            this.jooqmatePojoImplements = jooqmatePojoImplements;
        }

        public void setFields(List<FieldConfig> fields) {
            this.fields = fields;
        }

        public static class Header {
            @ExcelProperty(value={"ConfigName"}, index=0)
            String configName;
            @ExcelProperty(value={"ConfigValue1"}, index=1)
            String configValue1;
            @ExcelProperty(value={"ConfigValue2"}, index=2)
            String configValue2;

            public String getConfigName() {
                return this.configName;
            }

            public String getConfigValue1() {
                return this.configValue1;
            }

            public String getConfigValue2() {
                return this.configValue2;
            }

            public void setConfigName(String configName) {
                this.configName = configName;
            }

            public void setConfigValue1(String configValue1) {
                this.configValue1 = configValue1;
            }

            public void setConfigValue2(String configValue2) {
                this.configValue2 = configValue2;
            }
        }

        public static class FieldConfig {
            @ExcelProperty(index=0)
            private String fieldName;
            @ExcelProperty(index=1)
            private String fieldNameDesc;
            @ExcelProperty(index=2)
            private String dataType;
            @ExcelProperty(index=3)
            private String defaultValue = "";
            @ExcelProperty(index=4)
            private String enums = "";
            @ExcelProperty(index=5)
            private String example = "";
            @ExcelProperty(index=6)
            private boolean autoIncrement;
            @ExcelProperty(index=7)
            private String refKey;
            @ExcelProperty(index=8)
            private boolean generateEnum = true;
            private boolean uniqKey;

            public String getComment() {
                StringBuilder sb = new StringBuilder();
                sb.append(this.fieldNameDesc);
                if (!StringUtils.isEmpty((CharSequence)this.enums)) {
                    sb.append(" \\n@Enums ").append(this.enums);
                }
                if (!StringUtils.isEmpty((CharSequence)this.example)) {
                    sb.append(" \\n@Example ").append(this.example);
                }
                return sb.toString();
            }

            public String getFieldName() {
                return this.fieldName;
            }

            public String getFieldNameDesc() {
                return this.fieldNameDesc;
            }

            public String getDataType() {
                return this.dataType;
            }

            public String getDefaultValue() {
                return this.defaultValue;
            }

            public String getEnums() {
                return this.enums;
            }

            public String getExample() {
                return this.example;
            }

            public boolean isAutoIncrement() {
                return this.autoIncrement;
            }

            public String getRefKey() {
                return this.refKey;
            }

            public boolean isGenerateEnum() {
                return this.generateEnum;
            }

            public boolean isUniqKey() {
                return this.uniqKey;
            }

            public void setFieldName(String fieldName) {
                this.fieldName = fieldName;
            }

            public void setFieldNameDesc(String fieldNameDesc) {
                this.fieldNameDesc = fieldNameDesc;
            }

            public void setDataType(String dataType) {
                this.dataType = dataType;
            }

            public void setDefaultValue(String defaultValue) {
                this.defaultValue = defaultValue;
            }

            public void setEnums(String enums) {
                this.enums = enums;
            }

            public void setExample(String example) {
                this.example = example;
            }

            public void setAutoIncrement(boolean autoIncrement) {
                this.autoIncrement = autoIncrement;
            }

            public void setRefKey(String refKey) {
                this.refKey = refKey;
            }

            public void setGenerateEnum(boolean generateEnum) {
                this.generateEnum = generateEnum;
            }

            public void setUniqKey(boolean uniqKey) {
                this.uniqKey = uniqKey;
            }

            public String toString() {
                return "ConfigurationParser.TableConfig.FieldConfig(fieldName=" + this.fieldName + ", fieldNameDesc=" + this.fieldNameDesc + ", dataType=" + this.dataType + ", defaultValue=" + this.defaultValue + ", enums=" + this.enums + ", example=" + this.example + ", autoIncrement=" + this.autoIncrement + ", refKey=" + this.refKey + ", generateEnum=" + this.generateEnum + ", uniqKey=" + this.uniqKey + ")";
            }
        }

        public static class UniqKey {
            String name;
            String value;
            private Set<String> fieldNames = new HashSet<String>();

            public void setValue(String value) {
                this.value = value;
                this.fieldNames = new HashSet<String>(Arrays.asList(MateUtils.split(value, ",")));
            }

            public boolean contains(String fieldName) {
                return this.fieldNames.contains(fieldName);
            }

            public String getName() {
                return this.name;
            }

            public String getValue() {
                return this.value;
            }

            public Set<String> getFieldNames() {
                return this.fieldNames;
            }

            public void setName(String name) {
                this.name = name;
            }
        }
    }

    public static class JooqMateConfig {
        private int indent;
        private String directory;
        private String repoDirectory;
        private String serviceDirectory;
        private String apiDirectory;
        private String packageName;
        private String groupId;
        private String artifactId;
        private String projectDescription;
        private String[] ignoreFieldNames = new String[0];
        private String[] includeTableNames = new String[0];
        private String[] excludeTableNames = new String[0];
        private boolean generateInterface;
        private boolean generateRecord;
        private boolean generatePojo;
        private boolean generatePojoWithLombok;

        public int getIndent() {
            return this.indent;
        }

        public String getDirectory() {
            return this.directory;
        }

        public String getRepoDirectory() {
            return this.repoDirectory;
        }

        public String getServiceDirectory() {
            return this.serviceDirectory;
        }

        public String getApiDirectory() {
            return this.apiDirectory;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getProjectDescription() {
            return this.projectDescription;
        }

        public String[] getIgnoreFieldNames() {
            return this.ignoreFieldNames;
        }

        public String[] getIncludeTableNames() {
            return this.includeTableNames;
        }

        public String[] getExcludeTableNames() {
            return this.excludeTableNames;
        }

        public boolean isGenerateInterface() {
            return this.generateInterface;
        }

        public boolean isGenerateRecord() {
            return this.generateRecord;
        }

        public boolean isGeneratePojo() {
            return this.generatePojo;
        }

        public boolean isGeneratePojoWithLombok() {
            return this.generatePojoWithLombok;
        }

        public void setIndent(int indent) {
            this.indent = indent;
        }

        public void setDirectory(String directory) {
            this.directory = directory;
        }

        public void setRepoDirectory(String repoDirectory) {
            this.repoDirectory = repoDirectory;
        }

        public void setServiceDirectory(String serviceDirectory) {
            this.serviceDirectory = serviceDirectory;
        }

        public void setApiDirectory(String apiDirectory) {
            this.apiDirectory = apiDirectory;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        public void setProjectDescription(String projectDescription) {
            this.projectDescription = projectDescription;
        }

        public void setIgnoreFieldNames(String[] ignoreFieldNames) {
            this.ignoreFieldNames = ignoreFieldNames;
        }

        public void setIncludeTableNames(String[] includeTableNames) {
            this.includeTableNames = includeTableNames;
        }

        public void setExcludeTableNames(String[] excludeTableNames) {
            this.excludeTableNames = excludeTableNames;
        }

        public void setGenerateInterface(boolean generateInterface) {
            this.generateInterface = generateInterface;
        }

        public void setGenerateRecord(boolean generateRecord) {
            this.generateRecord = generateRecord;
        }

        public void setGeneratePojo(boolean generatePojo) {
            this.generatePojo = generatePojo;
        }

        public void setGeneratePojoWithLombok(boolean generatePojoWithLombok) {
            this.generatePojoWithLombok = generatePojoWithLombok;
        }

        public static class Header {
            @ExcelProperty(value={"ConfigName"}, index=0)
            String configName;
            @ExcelProperty(value={"ConfigValue"}, index=1)
            String configValue;

            public String getConfigName() {
                return this.configName;
            }

            public String getConfigValue() {
                return this.configValue;
            }

            public void setConfigName(String configName) {
                this.configName = configName;
            }

            public void setConfigValue(String configValue) {
                this.configValue = configValue;
            }

            public String toString() {
                return "ConfigurationParser.JooqMateConfig.Header(configName=" + this.configName + ", configValue=" + this.configValue + ")";
            }
        }
    }

    public static class JooqConfig {
        private String sqlDialect;
        private String url;
        private String user;
        private String password;
        private String inputSchema;
        private String directory;
        private String packageName;
        private boolean generateRecords;
        private boolean generatePojos;
        private boolean generateDaos;

        public String getSqlDialect() {
            return this.sqlDialect;
        }

        public String getUrl() {
            return this.url;
        }

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.password;
        }

        public String getInputSchema() {
            return this.inputSchema;
        }

        public String getDirectory() {
            return this.directory;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public boolean isGenerateRecords() {
            return this.generateRecords;
        }

        public boolean isGeneratePojos() {
            return this.generatePojos;
        }

        public boolean isGenerateDaos() {
            return this.generateDaos;
        }

        public void setSqlDialect(String sqlDialect) {
            this.sqlDialect = sqlDialect;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public void setInputSchema(String inputSchema) {
            this.inputSchema = inputSchema;
        }

        public void setDirectory(String directory) {
            this.directory = directory;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public void setGenerateRecords(boolean generateRecords) {
            this.generateRecords = generateRecords;
        }

        public void setGeneratePojos(boolean generatePojos) {
            this.generatePojos = generatePojos;
        }

        public void setGenerateDaos(boolean generateDaos) {
            this.generateDaos = generateDaos;
        }

        public static class Header {
            @ExcelProperty(value={"ConfigName"}, index=0)
            String configName;
            @ExcelProperty(value={"ConfigValue"}, index=1)
            String configValue;

            public String getConfigName() {
                return this.configName;
            }

            public String getConfigValue() {
                return this.configValue;
            }

            public void setConfigName(String configName) {
                this.configName = configName;
            }

            public void setConfigValue(String configValue) {
                this.configValue = configValue;
            }

            public String toString() {
                return "ConfigurationParser.JooqConfig.Header(configName=" + this.configName + ", configValue=" + this.configValue + ")";
            }
        }
    }

    public static class Config {
        JooqConfig jooqConfig = new JooqConfig();
        JooqMateConfig mateConfig = new JooqMateConfig();
        List<TableConfig> tables = new ArrayList<TableConfig>();
        private File projectTemplate;
        private Path directory;
        private MutableValueGraph<String, String> relationGraph = ValueGraphBuilder.directed().allowsSelfLoops(false).build();

        public Config addTable(TableConfig tc) {
            this.tables.add(tc);
            this.relationGraph.addNode((Object)tc.getTableName());
            if (!StringUtils.isEmpty((CharSequence)tc.getParentTableName())) {
                this.relationGraph.putEdgeValue((Object)tc.getParentTableName(), (Object)tc.getTableName(), (Object)"");
            }
            return this;
        }

        public List<String> tableNames() {
            return this.tables.stream().map(t -> ((TableConfig)t).tableName.trim()).collect(Collectors.toList());
        }

        public TableConfig getTableConfig(String tableName) {
            return this.tables.stream().filter(t -> ((TableConfig)t).tableName.equals(tableName)).findFirst().get();
        }

        public boolean isRootTable(String tableName) {
            return CollectionUtils.isEmpty((Collection)this.relationGraph.predecessors((Object)tableName));
        }

        public String jooqDirectory() {
            return this.getDirectory(this.jooqConfig.getDirectory());
        }

        public String jooqMateDirectory() {
            return this.getDirectory(this.mateConfig.getDirectory());
        }

        public String repoDirectory() {
            return this.getDirectory(MateUtils.firstNotEmpty(this.mateConfig.getRepoDirectory(), this.mateConfig.getDirectory()));
        }

        public String serviceDirectory() {
            return this.getDirectory(MateUtils.firstNotEmpty(this.mateConfig.getServiceDirectory(), this.mateConfig.getDirectory()));
        }

        public String apiDirectory() {
            return this.getDirectory(MateUtils.firstNotEmpty(this.mateConfig.getApiDirectory(), this.mateConfig.getDirectory()));
        }

        private String getDirectory(String path) {
            Path p = Paths.get(path, new String[0]);
            if (!p.isAbsolute() && this.directory != null) {
                return Paths.get(this.directory.toString(), p.toString()).toString();
            }
            return path;
        }

        public JooqConfig jooqConfig() {
            return this.jooqConfig;
        }

        public JooqMateConfig mateConfig() {
            return this.mateConfig;
        }

        public List<TableConfig> tables() {
            return this.tables;
        }

        public File projectTemplate() {
            return this.projectTemplate;
        }

        public Path directory() {
            return this.directory;
        }

        public MutableValueGraph<String, String> relationGraph() {
            return this.relationGraph;
        }

        public Config projectTemplate(File projectTemplate) {
            this.projectTemplate = projectTemplate;
            return this;
        }

        public Config directory(Path directory) {
            this.directory = directory;
            return this;
        }
    }

    private static class TableConfigListenerImpl
    extends AnalysisEventListener<TableConfig.Header> {
        private static final Logger log = LoggerFactory.getLogger(TableConfigListenerImpl.class);
        private TableConfig tableConfig;
        private boolean espectFiled;

        private TableConfigListenerImpl() {
        }

        public void invoke(TableConfig.Header data, AnalysisContext context) {
            if (data.getConfigName().equals("fieldName")) {
                this.espectFiled = true;
            } else if (this.espectFiled) {
                ReadRowHolder readRowHolder = context.readRowHolder();
                Map cellDataMap = readRowHolder.getCellMap();
                TableConfig.FieldConfig fc = this.buildFieldConfig(cellDataMap);
                this.tableConfig.addField(fc);
                log.info("field config readed: {}", (Object)fc);
            } else {
                Object value = ConfigurationParser.cast(data.getConfigName(), data.getConfigValue1(), this.tableConfig.getClass());
                if (value instanceof TableConfig.UniqKey) {
                    ((TableConfig.UniqKey)value).setName(data.getConfigValue1());
                    ((TableConfig.UniqKey)value).setValue(data.getConfigValue2());
                }
                if (value != null) {
                    TypeUtils.setValue((Object)this.tableConfig, (String)data.getConfigName(), (Object)value);
                }
                log.info("table config readed, {} : {}", (Object)data.getConfigName(), value);
            }
        }

        public void reset() {
            this.tableConfig = new TableConfig();
            this.espectFiled = false;
        }

        public void doAfterAllAnalysed(AnalysisContext context) {
        }

        private TableConfig.FieldConfig buildFieldConfig(Map<Integer, ReadCellData<?>> dataMap) {
            Field[] clazzFields;
            TableConfig.FieldConfig fc = new TableConfig.FieldConfig();
            for (Field f : clazzFields = TableConfig.FieldConfig.class.getDeclaredFields()) {
                Object value;
                String fieldName = f.getName();
                ExcelProperty anno = f.getAnnotation(ExcelProperty.class);
                if (anno == null) continue;
                int index = anno.index();
                ReadCellData<?> cellData = dataMap.get(index);
                Object object = value = cellData == null ? null : cellData.getStringValue();
                if (value == null) continue;
                value = ConfigurationParser.cast(fieldName, value, TableConfig.FieldConfig.class);
                TypeUtils.setValue((Object)fc, (String)fieldName, (Object)value);
            }
            return fc;
        }

        public TableConfig getTableConfig() {
            return this.tableConfig;
        }
    }

    private static class SingleTableListenerImpl<T>
    extends AnalysisEventListener<T> {
        private static final Logger log = LoggerFactory.getLogger(SingleTableListenerImpl.class);
        private List<T> datas = new ArrayList<T>();

        private SingleTableListenerImpl() {
        }

        public void invoke(T data, AnalysisContext context) {
            log.info("row readed: {}", data);
            this.datas.add(data);
        }

        public void doAfterAllAnalysed(AnalysisContext context) {
        }

        public List<T> getDatas() {
            return this.datas;
        }
    }
}

