/*
 * Decompiled with CFR 0.152.
 */
package org.cooder.jooq.mate;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.cooder.jooq.mate.FieldMeta;
import org.cooder.jooq.mate.TableMeta;
import org.cooder.jooq.mate.TypeGeneratorStrategy;
import org.jooq.tools.StringUtils;

public interface Generator {
    public static final String VALUE = "value";
    public static final String NAME = "name";

    public void generate(TableMeta var1);

    default public boolean ignore(TypeGeneratorStrategy strategy, TableMeta table, FieldMeta field) {
        return strategy.isIgnoreField(table.getName(), field.getName());
    }

    default public FieldMeta[] filterdFields(TypeGeneratorStrategy strategy, TableMeta table) {
        return Arrays.asList(table.fields()).stream().filter(f -> !this.ignore(strategy, table, (FieldMeta)f)).collect(Collectors.toList()).toArray(new FieldMeta[0]);
    }

    default public MethodSpec.Builder generateGetter(TableMeta table, FieldMeta field) {
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)("get" + StringUtils.toCamelCase((String)field.getName()))).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(field.getType()).addJavadoc("\u83b7\u53d6`" + field.getNameDesc() + "`", new Object[0]);
        return b;
    }

    default public void addSuppressWarnings(MethodSpec.Builder b) {
        b.addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember(VALUE, "{$S, $S}", new Object[]{"unchecked", "rawtypes"}).build());
    }

    default public MethodSpec.Builder generateSetter(TableMeta table, FieldMeta field) {
        String nameLC = StringUtils.toCamelCaseLC((String)field.getName());
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)("set" + StringUtils.toCamelCase((String)field.getName()))).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(field.getType(), nameLC, new Modifier[0]).returns(Void.TYPE).addJavadoc("\u8bbe\u7f6e`" + field.getNameDesc() + "`", new Object[0]);
        return b;
    }

    default public TypeName subTableFieldType(TypeGeneratorStrategy strategy, String subTableName) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{strategy.pojoClassName(subTableName)});
    }

    default public void output(String indent, String directory, String packageName, TypeSpec typeSpec) {
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)typeSpec).indent(indent).skipJavaLangImports(true).addFileComment("\nThis file is generated by JOOQ-MATE.\n", new Object[0]).build();
        try {
            javaFile.writeTo(new File(directory));
        }
        catch (IOException e) {
            throw new RuntimeException("failed to write file.", e);
        }
        System.out.println(String.format("generated: %s.%s", packageName, typeSpec.name));
    }
}

