/*
 * Decompiled with CFR 0.152.
 */
package org.cooder.jooq.mate;

import java.util.ArrayList;
import java.util.List;
import org.cooder.jooq.mate.ConfigurationParser;
import org.jooq.CloseableDSLContext;
import org.jooq.codegen.GenerationTool;
import org.jooq.impl.DSL;
import org.jooq.meta.jaxb.Configuration;
import org.jooq.meta.jaxb.Database;
import org.jooq.meta.jaxb.Generate;
import org.jooq.meta.jaxb.Generator;
import org.jooq.meta.jaxb.Jdbc;
import org.jooq.meta.jaxb.MatcherRule;
import org.jooq.meta.jaxb.MatcherTransformType;
import org.jooq.meta.jaxb.Matchers;
import org.jooq.meta.jaxb.MatchersTableType;
import org.jooq.meta.jaxb.Strategy;
import org.jooq.meta.jaxb.Target;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JooqGenerator {
    private static final Logger log = LoggerFactory.getLogger(JooqGenerator.class);
    private final Configuration configuration = new Configuration();

    public JooqGenerator(ConfigurationParser.Config conf) {
        ConfigurationParser.JooqConfig jc = conf.jooqConfig();
        String includeTables = String.join((CharSequence)"|", conf.tableNames());
        List<MatchersTableType> tableStrategies = this.buildTableStrategies(conf.tables());
        this.configuration.withJdbc(new Jdbc().withDriver("com.mysql.cj.jdbc.Driver").withUrl(jc.getUrl()).withUser(jc.getUser()).withPassword(jc.getPassword())).withGenerator(new Generator().withDatabase(new Database().withName("org.jooq.meta.mysql.MySQLDatabase").withInputSchema(jc.getInputSchema()).withOutputSchemaToDefault(Boolean.valueOf(true)).withIncludes(includeTables)).withGenerate(new Generate().withDaos(Boolean.valueOf(jc.isGenerateDaos())).withRecords(Boolean.valueOf(jc.isGenerateRecords())).withPojos(Boolean.valueOf(jc.isGeneratePojos()))).withTarget(new Target().withPackageName(jc.getPackageName()).withDirectory(conf.jooqDirectory())).withStrategy(new Strategy().withMatchers(new Matchers().withTables(tableStrategies))));
    }

    public void executeDDL(ConfigurationParser.JooqConfig jc, List<String> sqls) {
        log.info("generate database tables: ");
        sqls.forEach(arg_0 -> ((Logger)log).info(arg_0));
        CloseableDSLContext db = DSL.using((String)jc.getUrl(), (String)jc.getUser(), (String)jc.getPassword());
        db.batch(sqls.toArray(new String[0])).execute();
    }

    public void generate() throws Exception {
        new GenerationTool().run(this.configuration);
    }

    private List<MatchersTableType> buildTableStrategies(List<ConfigurationParser.TableConfig> tables) {
        ArrayList<MatchersTableType> ret = new ArrayList<MatchersTableType>();
        tables.forEach(tc -> {
            MatchersTableType type = new MatchersTableType();
            type.withExpression(tc.getTableName());
            type.withDaoClass(new MatcherRule().withTransform(MatcherTransformType.PASCAL).withExpression(tc.getJooqDaoClass()));
            type.withPojoClass(new MatcherRule().withTransform(MatcherTransformType.PASCAL).withExpression(tc.getJooqPojoClass()));
            type.withPojoImplements(tc.getJooqPojoImplements());
            ret.add(type);
        });
        return ret;
    }
}

