/*
 * Decompiled with CFR 0.152.
 */
package org.cooder.jooq.mate;

import java.io.File;
import java.util.List;
import java.util.concurrent.Callable;
import org.cooder.jooq.mate.ConfigurationParser;
import org.cooder.jooq.mate.JooqGenerator;
import org.cooder.jooq.mate.ProjectGenerator;
import org.cooder.jooq.mate.SqlGenerator;
import org.cooder.jooq.mate.TypeGenerator;
import picocli.CommandLine;

@CommandLine.Command(name="MateGeneratorTool")
public class MateGeneratorTool
implements Callable<Integer> {
    @CommandLine.Parameters(index="0", description={"config file"})
    private String file;
    @CommandLine.Option(names={"-ct", "--createTable"})
    private boolean createTable = false;
    @CommandLine.Option(names={"-jc", "--jooqCodegen"})
    private boolean jooqCodegen = false;
    @CommandLine.Option(names={"-cpf", "--createProjectFrom"}, paramLabel="FILE", description={"path of the project template dir"})
    private File projectTemplate;

    public static void main(String[] args) {
        int exitCode = new CommandLine((Object)new MateGeneratorTool()).execute(args);
        System.exit(exitCode);
    }

    @Override
    public Integer call() throws Exception {
        this.generate(this.file);
        return 0;
    }

    private void generate(String file) throws Exception {
        if (this.projectTemplate != null && !this.projectTemplate.exists()) {
            System.err.println("unexist: " + this.projectTemplate.getAbsolutePath());
            return;
        }
        ConfigurationParser.Config conf = new ConfigurationParser().parse(file);
        conf.projectTemplate(this.projectTemplate);
        new ProjectGenerator().generate(conf);
        List<String> sqls = new SqlGenerator().generate(conf);
        for (String sql : sqls) {
            System.out.println(sql);
        }
        JooqGenerator jooq = new JooqGenerator(conf);
        if (this.createTable) {
            jooq.executeDDL(conf.jooqConfig(), sqls);
        }
        if (this.jooqCodegen) {
            jooq.generate();
        }
        new TypeGenerator().generate(conf);
    }
}

