/*
 * Decompiled with CFR 0.152.
 */
package org.cooder.jooq.mate;

import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.cooder.jooq.mate.ConfigurationParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectGenerator {
    private static final Logger log = LoggerFactory.getLogger(ProjectGenerator.class);

    public void generate(ConfigurationParser.Config conf) throws IOException {
        if (conf.projectTemplate() == null || !conf.projectTemplate().exists()) {
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("artifactId", conf.mateConfig.getArtifactId());
        params.put("groupId", conf.mateConfig.getGroupId());
        params.put("projectDescription", conf.mateConfig.getProjectDescription());
        params.put("datasource.url", conf.jooqConfig.getUrl());
        params.put("datasource.username", conf.jooqConfig.getUser());
        params.put("datasource.password", conf.jooqConfig.getPassword());
        Path destPath = Paths.get(".", "target", "generated-projects", conf.mateConfig.getArtifactId());
        ProjectGenerator.copyDirectory(conf.projectTemplate().getAbsolutePath(), destPath.toString(), params);
        conf.directory(destPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyDirectory(String sourceDir, String targetDir, Map<String, String> params) throws IOException {
        log.info("copy {} to {}", (Object)sourceDir, (Object)targetDir);
        try (Stream<Path> s = Files.walk(Paths.get(sourceDir, new String[0]), new FileVisitOption[0]);){
            s.forEach(file -> {
                block17: {
                    String srcPathStr = file.toString();
                    Path destination = Paths.get(targetDir, srcPathStr.substring(sourceDir.length()));
                    try {
                        log.info("copy {} to {}", file, (Object)destination);
                        if (file.toFile().isDirectory()) {
                            destination.toFile().mkdirs();
                            break block17;
                        }
                        if (srcPathStr.endsWith(".xml") || srcPathStr.endsWith(".yml") || srcPathStr.endsWith(".properties")) {
                            try (FileOutputStream fos = new FileOutputStream(destination.toFile());){
                                List<String> lines = Files.readAllLines(file);
                                for (String line : lines) {
                                    String newLine = ProjectGenerator.replace(line, params) + "\n";
                                    fos.write(newLine.getBytes());
                                }
                                break block17;
                            }
                        }
                        Files.copy(file, destination, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
    }

    private static String replace(String text, Map<String, String> map) {
        return ProjectGenerator.parse("${", "}", text, map);
    }

    public static String parse(String openToken, String closeToken, String text, Map<String, String> map) {
        if (map == null || map.size() == 0) {
            return text;
        }
        if (text == null || text.isEmpty()) {
            return "";
        }
        char[] src = text.toCharArray();
        int offset = 0;
        int start = text.indexOf(openToken, offset);
        if (start == -1) {
            return text;
        }
        StringBuilder builder = new StringBuilder();
        StringBuilder expression = null;
        while (start > -1) {
            if (start > 0 && src[start - 1] == '\\') {
                builder.append(src, offset, start - offset - 1).append(openToken);
                offset = start + openToken.length();
            } else {
                if (expression == null) {
                    expression = new StringBuilder();
                } else {
                    expression.setLength(0);
                }
                builder.append(src, offset, start - offset);
                offset = start + openToken.length();
                int end = text.indexOf(closeToken, offset);
                while (end > -1) {
                    if (end > offset && src[end - 1] == '\\') {
                        expression.append(src, offset, end - offset - 1).append(closeToken);
                        offset = end + closeToken.length();
                        end = text.indexOf(closeToken, offset);
                        continue;
                    }
                    expression.append(src, offset, end - offset);
                    offset = end + closeToken.length();
                    break;
                }
                if (end == -1) {
                    builder.append(src, start, src.length - start);
                    offset = src.length;
                } else {
                    String key = text.substring(start + openToken.length(), end);
                    String value = map.containsKey(key) ? map.get(key) : openToken + key + closeToken;
                    builder.append(value == null ? "" : value.replaceAll("\\\\", "/"));
                    offset = end + closeToken.length();
                }
            }
            start = text.indexOf(openToken, offset);
        }
        if (offset < src.length) {
            builder.append(src, offset, src.length - offset);
        }
        return builder.toString();
    }
}

