/*
 * Decompiled with CFR 0.152.
 */
package org.cooder.jooq.mate;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.lang.model.element.Modifier;
import org.cooder.jooq.mate.FieldMeta;
import org.cooder.jooq.mate.Generator;
import org.cooder.jooq.mate.TableMeta;
import org.cooder.jooq.mate.TypeGeneratorStrategy;
import org.cooder.jooq.mate.types.db.RepoUtils;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.SelectConditionStep;
import org.jooq.SelectSelectStep;
import org.jooq.Table;
import org.jooq.UpdateConditionStep;
import org.jooq.impl.DSL;
import org.jooq.tools.StringUtils;
import org.springframework.stereotype.Repository;

class RepoGenerator
implements Generator {
    private final TypeGeneratorStrategy strategy;

    public RepoGenerator(TypeGeneratorStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public void generate(TableMeta table) {
        String tableName = table.getName();
        if (!this.strategy.isGenerateRepo(tableName)) {
            return;
        }
        ClassName repoCN = this.strategy.repoClassName(tableName);
        TypeSpec.Builder ts = TypeSpec.classBuilder((String)repoCN.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Repository.class);
        ts.addField(FieldSpec.builder(DSLContext.class, (String)"db", (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(Resource.class).build());
        this.generateCreater(ts, table);
        if (table.hasUniqKey()) {
            this.generateUpdaterwhere(ts, table);
            this.generateFlatGetter(ts, table);
            this.generateFlatGetterAll(ts, table);
        } else {
            this.generateUpdater(ts, table);
            this.generateGetter(ts, table);
        }
        this.generateLister(ts, table);
        this.output(this.strategy.getIndent(), this.strategy.getRepoDirectory(), this.strategy.repoPackageName(tableName), ts.build());
    }

    private void generateCreater(TypeSpec.Builder ts, TableMeta table) {
        MethodSpec.Builder b = this.generateMethod(table, "create");
        b.returns(Void.TYPE);
        b.addCode(CodeBlock.builder().addStatement("rec.insert()", new Object[0]).build());
        ts.addMethod(b.build());
    }

    private void generateUpdater(TypeSpec.Builder ts, TableMeta table) {
        MethodSpec.Builder b = this.generateMethod(table, "update");
        b.returns(Void.TYPE);
        b.addCode(CodeBlock.builder().addStatement("rec.update()", new Object[0]).build());
        ts.addMethod(b.build());
    }

    private void generateUpdaterwhere(TypeSpec.Builder ts, TableMeta table) {
        MethodSpec.Builder b = this.generateMethod(table, "update");
        this.addSuppressWarnings(b);
        b.returns(Void.TYPE);
        b.addStatement("$T sql = db.update(rec.getTable()).set(rec).where($T.noCondition())", new Object[]{UpdateConditionStep.class, DSL.class});
        for (FieldMeta f : table.fields()) {
            if (!f.isUniqKey()) continue;
            b.addStatement("sql = sql.and(table.field($S, $T.class).eq(rec.get($S, $T.class)))", new Object[]{f.getName(), f.getType(), f.getName(), f.getType()});
        }
        b.addStatement("sql.execute()", new Object[0]);
        ts.addMethod(b.build());
    }

    private void generateGetter(TypeSpec.Builder ts, TableMeta table) {
        String tableName = table.getName();
        ClassName pojoCN = this.strategy.pojoClassName(tableName);
        MethodSpec.Builder b = this.generateMethod(table, "get");
        this.addSuppressWarnings(b);
        b.returns((TypeName)pojoCN);
        b.addCode(CodeBlock.builder().addStatement("$T sql = db.selectFrom(rec.getTable()).where($T.noCondition())", new Object[]{SelectConditionStep.class, DSL.class}).addStatement("$T[] fields = rec.fields()", new Object[]{Field.class}).beginControlFlow("for ($T field : fields)", new Object[]{Field.class}).beginControlFlow("if (field.changed(rec))", new Object[0]).addStatement("sql = sql.and(field.eq(rec.get(field)))", new Object[0]).endControlFlow().endControlFlow().addStatement("return sql.fetchOne().into($T.class)", new Object[]{pojoCN}).build());
        ts.addMethod(b.build());
    }

    private void generateFlatGetter(TypeSpec.Builder ts, TableMeta table) {
        String tableName = table.getName();
        ClassName intrCN = this.strategy.interfaceClassName(tableName);
        ClassName pojoCN = this.strategy.pojoClassName(tableName);
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)("get" + intrCN.simpleName())).addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (FieldMeta f : table.fields()) {
            if (!f.isUniqKey()) continue;
            b.addParameter(f.getType(), StringUtils.toCamelCaseLC((String)f.getName()), new Modifier[0]);
        }
        this.addSuppressWarnings(b);
        b.returns((TypeName)pojoCN);
        ClassName jooqRecordCN = this.strategy.jooqRecordClassName(tableName);
        b.addStatement("$T rec  = new $T()", new Object[]{jooqRecordCN, jooqRecordCN});
        b.addStatement("$T table = rec.getTable()", new Object[]{Table.class});
        b.addCode("\n", new Object[0]).addStatement("$T sql = db.selectFrom(table).where($L)", new Object[]{SelectConditionStep.class, this.generateMainTableWhere(table)});
        b.addStatement("return sql.fetchOne().into($T.class)", new Object[]{pojoCN});
        ts.addMethod(b.build());
    }

    private CodeBlock generateMainTableWhere(TableMeta tm) {
        CodeBlock.Builder cb = CodeBlock.builder();
        cb.add("$T.noCondition()", new Object[]{DSL.class});
        for (FieldMeta f : tm.fields()) {
            if (!f.isUniqKey()) continue;
            String nameLC = StringUtils.toCamelCaseLC((String)f.getName());
            cb.add(".and(table.field($S, $T.class).eq($L))", new Object[]{f.getName(), f.getType(), nameLC});
        }
        return cb.build();
    }

    private void generateFlatGetterAll(TypeSpec.Builder ts, TableMeta table) {
        String tableName = table.getName();
        List<TableMeta> subTables = this.strategy.subTables(tableName);
        if (subTables.isEmpty()) {
            return;
        }
        ClassName intrCN = this.strategy.interfaceClassName(tableName);
        ClassName pojoCN = this.strategy.pojoAllClassName(tableName);
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)("get" + intrCN.simpleName() + "All")).addModifiers(new Modifier[]{Modifier.PUBLIC});
        ArrayList<String> keys = new ArrayList<String>();
        for (FieldMeta f : table.fields()) {
            if (!f.isUniqKey()) continue;
            b.addParameter(f.getType(), StringUtils.toCamelCaseLC((String)f.getName()), new Modifier[0]);
            keys.add(f.getName().toUpperCase());
        }
        this.addSuppressWarnings(b);
        b.returns((TypeName)pojoCN);
        b.addStatement(this.generateDefineVarTable("table", tableName));
        subTables.forEach(st -> b.addStatement(this.generateDefineVarTable(this.strategy.jooqTableVarName(st.getName()), st.getName())));
        b.addCode("\n", new Object[0]);
        b.addStatement("$T sql = db.select(table.fields())", new Object[]{SelectSelectStep.class});
        subTables.forEach(st -> b.addStatement("sql = sql.select($T.field($L).as($S))", new Object[]{DSL.class, this.generateSubTableSelect((TableMeta)st, (List<String>)keys), StringUtils.toCamelCaseLC((String)st.getName()) + "List"}));
        b.addStatement("return sql.from(table)\n    .where($L)\n    .fetchOne().into($T.class)", new Object[]{this.generateMainTableWhere(table), pojoCN});
        ts.addMethod(b.build());
    }

    private CodeBlock generateSubTableSelect(TableMeta st, List<String> keys) {
        CodeBlock.Builder cb = CodeBlock.builder();
        ClassName recordCN = this.strategy.recordClassName(st.getName());
        String jooqTableVarName = this.strategy.jooqTableVarName(st.getName());
        cb.add("$T.select($T.jsonArrayAgg($L, $T.FIELDS))\n    .from($L)\n    .where($L)\n", new Object[]{DSL.class, RepoUtils.class, jooqTableVarName, recordCN, jooqTableVarName, this.generateWhere(st, keys)});
        return cb.build();
    }

    private CodeBlock generateWhere(TableMeta st, List<String> keys) {
        CodeBlock.Builder cb = CodeBlock.builder();
        String jooqTableVarName = this.strategy.jooqTableVarName(st.getName());
        for (int i = 0; i < keys.size(); ++i) {
            String key = keys.get(i);
            CodeBlock cbt = CodeBlock.builder().add("table.$L.eq($L.$L)", new Object[]{key, jooqTableVarName, key}).build();
            if (i == 0) {
                cb.add(cbt);
                continue;
            }
            cb.add(".and($L)", new Object[]{cbt});
        }
        return cb.build();
    }

    private CodeBlock generateDefineVarTable(String varName, String tableName) {
        ClassName jooqTableCN = this.strategy.jooqTableClassName(tableName);
        return CodeBlock.builder().add("$T $L = $T.$L", new Object[]{jooqTableCN, varName, jooqTableCN, tableName.toUpperCase()}).build();
    }

    private void generateLister(TypeSpec.Builder ts, TableMeta table) {
        String tableName = table.getName();
        ClassName pojoCN = this.strategy.pojoClassName(tableName);
        MethodSpec.Builder b = this.generateMethod(table, "list");
        this.addSuppressWarnings(b);
        b.returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{pojoCN}));
        b.addCode(CodeBlock.builder().addStatement("$T sql = db.selectFrom(rec.getTable()).where($T.noCondition())", new Object[]{SelectConditionStep.class, DSL.class}).addStatement("$T[] fields = rec.fields()", new Object[]{Field.class}).beginControlFlow("for ($T field : fields)", new Object[]{Field.class}).beginControlFlow("if (field.changed(rec))", new Object[0]).addStatement("sql = sql.and(field.eq(rec.get(field)))", new Object[0]).endControlFlow().endControlFlow().addStatement("return sql.fetch().into($T.class)", new Object[]{pojoCN}).build());
        ts.addMethod(b.build());
    }

    private MethodSpec.Builder generateMethod(TableMeta table, String type) {
        String tableName = table.getName();
        ClassName intrCN = this.strategy.interfaceClassName(tableName);
        ClassName pojoCN = this.strategy.pojoClassName(tableName);
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)(type + intrCN.simpleName())).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)pojoCN, "entity", new Modifier[0]);
        ClassName jooqRecordCN = this.strategy.jooqRecordClassName(tableName);
        b.addStatement("$T rec  = new $T()", new Object[]{jooqRecordCN, jooqRecordCN});
        b.addStatement("rec.from(entity)", new Object[0]);
        b.addStatement("$T<$T> table = rec.getTable()", new Object[]{Table.class, jooqRecordCN});
        b.addStatement("rec.attach(db.configuration())", new Object[0]);
        b.addCode("\n", new Object[0]);
        return b;
    }

    public static RepoGenerator of(TypeGeneratorStrategy strategy) {
        return new RepoGenerator(strategy);
    }
}

