/*
 * Decompiled with CFR 0.152.
 */
package org.cooder.jooq.mate;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.lang.model.element.Modifier;
import org.cooder.jooq.mate.FieldMeta;
import org.cooder.jooq.mate.Generator;
import org.cooder.jooq.mate.TableMeta;
import org.cooder.jooq.mate.TypeGeneratorStrategy;
import org.jooq.tools.StringUtils;
import org.springframework.stereotype.Service;

class ServiceGenerator
implements Generator {
    private final TypeGeneratorStrategy strategy;

    public ServiceGenerator(TypeGeneratorStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public void generate(TableMeta table) {
        if (!this.strategy.isRootTable(table)) {
            return;
        }
        String tableName = table.getName();
        ClassName serviceCN = this.strategy.serviceClassName(tableName);
        TypeSpec.Builder ts = TypeSpec.classBuilder((String)serviceCN.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Service.class);
        String repoClazzNameLC = StringUtils.toLC((String)this.strategy.repoClazzName(tableName));
        ts.addField(FieldSpec.builder((TypeName)this.strategy.repoClassName(tableName), (String)repoClazzNameLC, (Modifier[])new Modifier[]{Modifier.PRIVATE}).addAnnotation(Resource.class).build());
        this.generateCreater(ts, table);
        this.generateUpdater(ts, table);
        if (table.hasUniqKey()) {
            this.generateFlatGetter(ts, table);
        } else {
            this.generateGetter(ts, table);
        }
        this.generateLister(ts, table);
        this.output(this.strategy.getIndent(), this.strategy.getServiceDirectory(), this.strategy.servicePackageName(tableName), ts.build());
    }

    private void generateCreater(TypeSpec.Builder ts, TableMeta table) {
        String repoClazzNameLC = StringUtils.toLC((String)this.strategy.repoClazzName(table.getName()));
        MethodSpec.Builder b = this.generateMethod(table, "create");
        b.returns(Void.TYPE);
        b.addCode(CodeBlock.builder().addStatement("$L.$L(entity)", new Object[]{repoClazzNameLC, b.build().name}).build());
        ts.addMethod(b.build());
    }

    private void generateUpdater(TypeSpec.Builder ts, TableMeta table) {
        String repoClazzNameLC = StringUtils.toLC((String)this.strategy.repoClazzName(table.getName()));
        MethodSpec.Builder b = this.generateMethod(table, "update");
        b.returns(Void.TYPE);
        b.addCode(CodeBlock.builder().addStatement("$L.$L(entity)", new Object[]{repoClazzNameLC, b.build().name}).build());
        ts.addMethod(b.build());
    }

    private void generateGetter(TypeSpec.Builder ts, TableMeta table) {
        String repoClazzNameLC = StringUtils.toLC((String)this.strategy.repoClazzName(table.getName()));
        String tableName = table.getName();
        ClassName pojoCN = this.strategy.pojoClassName(tableName);
        MethodSpec.Builder b = this.generateMethod(table, "get");
        b.returns((TypeName)pojoCN);
        b.addCode(CodeBlock.builder().addStatement("return $L.$L(entity)", new Object[]{repoClazzNameLC, b.build().name}).build());
        ts.addMethod(b.build());
    }

    private void generateFlatGetter(TypeSpec.Builder ts, TableMeta table) {
        String repoClazzNameLC = StringUtils.toLC((String)this.strategy.repoClazzName(table.getName()));
        String tableName = table.getName();
        ClassName intrCN = this.strategy.interfaceClassName(tableName);
        ClassName pojoCN = this.strategy.pojoClassName(tableName);
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)("get" + intrCN.simpleName())).addModifiers(new Modifier[]{Modifier.PUBLIC});
        ArrayList<String> paramrers = new ArrayList<String>();
        for (FieldMeta f : table.fields()) {
            if (!f.isUniqKey()) continue;
            b.addParameter(f.getType(), StringUtils.toCamelCaseLC((String)f.getName()), new Modifier[0]);
            paramrers.add(StringUtils.toCamelCaseLC((String)f.getName()));
        }
        b.returns((TypeName)pojoCN);
        b.addCode(CodeBlock.builder().addStatement("return $L.$L($L)", new Object[]{repoClazzNameLC, b.build().name, StringUtils.join((Object[])paramrers.toArray(new String[0]), (String)", ")}).build());
        ts.addMethod(b.build());
    }

    private void generateLister(TypeSpec.Builder ts, TableMeta table) {
        String repoClazzNameLC = StringUtils.toLC((String)this.strategy.repoClazzName(table.getName()));
        String tableName = table.getName();
        ClassName pojoCN = this.strategy.pojoClassName(tableName);
        MethodSpec.Builder b = this.generateMethod(table, "list");
        b.returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{pojoCN}));
        b.addCode(CodeBlock.builder().addStatement("return $L.$L(entity)", new Object[]{repoClazzNameLC, b.build().name}).build());
        ts.addMethod(b.build());
    }

    private MethodSpec.Builder generateMethod(TableMeta table, String type) {
        String tableName = table.getName();
        ClassName intrCN = this.strategy.interfaceClassName(tableName);
        ClassName pojoCN = this.strategy.pojoClassName(tableName);
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)(type + intrCN.simpleName())).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)pojoCN, "entity", new Modifier[0]);
        return b;
    }

    public static ServiceGenerator of(TypeGeneratorStrategy strategy) {
        return new ServiceGenerator(strategy);
    }
}

