/*
 * Decompiled with CFR 0.152.
 */
package org.cooder.jooq.mate;

import java.math.BigDecimal;
import java.time.LocalTime;
import java.util.List;
import org.cooder.jooq.mate.ApiGenerator;
import org.cooder.jooq.mate.ConfigurationParser;
import org.cooder.jooq.mate.FieldMeta;
import org.cooder.jooq.mate.Generator;
import org.cooder.jooq.mate.RepoGenerator;
import org.cooder.jooq.mate.ServiceGenerator;
import org.cooder.jooq.mate.TableMeta;
import org.cooder.jooq.mate.TypeGeneratorStrategy;
import org.cooder.jooq.mate.TypeInterfaceGenerator;
import org.cooder.jooq.mate.TypePojoAllGenerator;
import org.cooder.jooq.mate.TypePojoGenerator;
import org.cooder.jooq.mate.TypeRecordGenerator;
import org.jooq.Field;
import org.jooq.impl.TableImpl;
import org.jooq.tools.StringUtils;

public class TypeGenerator
implements Generator {
    private TypeGeneratorStrategy strategy;

    public TypeGenerator() {
        this(new TypeGeneratorStrategy());
    }

    public TypeGenerator(TypeGeneratorStrategy strategy) {
        this.strategy = strategy;
    }

    public void generate(ConfigurationParser.Config conf) {
        this.withConfig(conf);
        List<ConfigurationParser.TableConfig> tbs = conf.tables();
        for (ConfigurationParser.TableConfig tc : tbs) {
            this.generate(new TableConfigMeta(tc));
        }
    }

    public void generateTables(String tablesClassName) throws Exception {
        java.lang.reflect.Field[] fs;
        for (java.lang.reflect.Field f : fs = Class.forName(tablesClassName).getDeclaredFields()) {
            Object table;
            if ((f.getModifiers() & 1) <= 0 || !((table = f.get(null)) instanceof TableImpl)) continue;
            this.generate(new JooqTableMeta((TableImpl)table));
        }
    }

    @Override
    public void generate(TableMeta table) {
        if (this.ignoreTable(table)) {
            return;
        }
        TypeInterfaceGenerator.of(this.strategy).generate(table);
        TypeRecordGenerator.of(this.strategy).generate(table);
        TypePojoGenerator.of(this.strategy).generate(table);
        TypePojoAllGenerator.of(this.strategy).generate(table);
        RepoGenerator.of(this.strategy).generate(table);
        ServiceGenerator.of(this.strategy).generate(table);
        ApiGenerator.of(this.strategy).generate(table);
    }

    private boolean ignoreTable(TableMeta table) {
        return this.strategy.isIgnoreTable(table.getName());
    }

    private void withConfig(ConfigurationParser.Config conf) {
        ConfigurationParser.JooqMateConfig mc = conf.mateConfig;
        this.strategy.withDirectory(conf.jooqMateDirectory()).withRepoDirectory(conf.repoDirectory()).withServiceDirectory(conf.serviceDirectory()).withApiDirectory(conf.apiDirectory()).withPackageName(mc.getPackageName()).ignoreFieldNames(mc.getIgnoreFieldNames()).includeTableNames(mc.getIncludeTableNames()).excludeTableNames(mc.getExcludeTableNames()).generateInterface(mc.isGenerateInterface()).generateRecord(mc.isGenerateRecord()).generatePojo(mc.isGeneratePojo()).generatePojoWithLombok(mc.isGeneratePojoWithLombok()).withInterfaceNameConverter((s, tableName) -> conf.getTableConfig((String)tableName).getJooqmateInterfaceName()).withRecordNameConverter((s, tableName) -> conf.getTableConfig((String)tableName).getJooqmateRecordName()).withPojoNameConverter((s, tableName) -> conf.getTableConfig((String)tableName).getJooqmatePojoName());
        this.strategy.setJooqPackageName(conf.jooqConfig().getPackageName());
        for (ConfigurationParser.TableConfig tc : conf.tables) {
            this.strategy.withTableStrategy(tc.getTableName(), new TypeGeneratorStrategy.TableStrategy().setSubPackageName(tc.getJooqmateSubpackage()).ignoreFieldNames(tc.getJooqmateIgnoreFieldNames()).setGeneratedInterfaceSuperInterfaces(tc.getJooqmateInterfaceSupers()).setGeneratedPojoSuperClass(tc.getJooqmatePojoSuperClass()));
        }
        this.strategy.withConfig(conf);
    }

    static class FieldConfigMeta
    implements FieldMeta {
        private ConfigurationParser.TableConfig.FieldConfig fieldConfig;

        public FieldConfigMeta(ConfigurationParser.TableConfig.FieldConfig fieldConfig) {
            this.fieldConfig = fieldConfig;
        }

        @Override
        public String getName() {
            return this.fieldConfig.getFieldName();
        }

        @Override
        public Class<?> getType() {
            Class clazz = null;
            String dataType = this.fieldConfig.getDataType().toUpperCase();
            if (dataType.contains("BIGINT")) {
                clazz = Long.class;
            } else if (dataType.contains("INT")) {
                clazz = Integer.class;
            } else if (dataType.contains("CHAR") || dataType.contains("TEXT")) {
                clazz = String.class;
            } else if (dataType.contains("DECIMAL")) {
                clazz = BigDecimal.class;
            } else if (dataType.contains("TIMESTAMP")) {
                clazz = LocalTime.class;
            }
            return clazz;
        }

        @Override
        public String getComment() {
            boolean hasMore = false;
            StringBuilder sb = new StringBuilder();
            sb.append(this.fieldConfig.getFieldNameDesc()).append("\n");
            if (!StringUtils.isEmpty((String)this.fieldConfig.getEnums())) {
                sb.append('\n');
                sb.append("\u53d6\u503c\u8bf4\u660e: ").append(this.fieldConfig.getEnums()).append("\n");
                hasMore = true;
            }
            if (!StringUtils.isEmpty((String)this.fieldConfig.getExample())) {
                if (!hasMore) {
                    sb.append('\n');
                }
                sb.append("\u4f8b\u5982:  ").append(this.fieldConfig.getExample()).append("\n");
            }
            return sb.toString();
        }

        @Override
        public String getNameDesc() {
            return this.fieldConfig.getFieldNameDesc();
        }

        @Override
        public String getEnums() {
            return this.fieldConfig.getEnums();
        }

        @Override
        public boolean isUniqKey() {
            return this.fieldConfig.isUniqKey();
        }

        @Override
        public boolean isGenerateEnum() {
            return this.fieldConfig.isGenerateEnum();
        }
    }

    static class TableConfigMeta
    implements TableMeta {
        private ConfigurationParser.TableConfig tableConfig;

        public TableConfigMeta(ConfigurationParser.TableConfig tc) {
            this.tableConfig = tc;
        }

        @Override
        public String getName() {
            return this.tableConfig.getTableName();
        }

        @Override
        public String getComment() {
            return String.format("%s<br>\n\n%s", this.tableConfig.getTableNameDesc(), this.tableConfig.getTableDesc());
        }

        @Override
        public FieldMeta[] fields() {
            List<ConfigurationParser.TableConfig.FieldConfig> fs = this.tableConfig.getFields();
            FieldMeta[] ret = new FieldMeta[fs.size()];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = new FieldConfigMeta(fs.get(i));
            }
            return ret;
        }

        @Override
        public boolean hasUniqKey() {
            return this.tableConfig.getUniqueKey() != null;
        }

        @Override
        public String getNameDesc() {
            return this.tableConfig.getTableNameDesc();
        }
    }

    private static class JooqFieldMeta
    implements FieldMeta {
        private final Field<?> field;

        public JooqFieldMeta(Field<?> field) {
            this.field = field;
        }

        @Override
        public String getName() {
            return this.field.getName();
        }

        @Override
        public Class<?> getType() {
            return this.field.getType();
        }

        @Override
        public String getComment() {
            return this.field.getComment();
        }
    }

    private static class JooqTableMeta
    implements TableMeta {
        private final TableImpl<?> table;

        public JooqTableMeta(TableImpl<?> table) {
            this.table = table;
        }

        @Override
        public String getName() {
            return this.table.getName();
        }

        @Override
        public String getComment() {
            return this.table.getComment();
        }

        @Override
        public FieldMeta[] fields() {
            Field[] fs = this.table.fields();
            FieldMeta[] metas = new FieldMeta[fs.length];
            for (int i = 0; i < fs.length; ++i) {
                metas[i] = new JooqFieldMeta(fs[i]);
            }
            return metas;
        }
    }
}

