/*
 * Decompiled with CFR 0.152.
 */
package org.cooder.jooq.mate;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.cooder.jooq.mate.ApiGeneratorStrategy;
import org.cooder.jooq.mate.ConfigurationParser;
import org.cooder.jooq.mate.GeneratorStrategy;
import org.cooder.jooq.mate.MateUtils;
import org.cooder.jooq.mate.RepoGeneratorStrategy;
import org.cooder.jooq.mate.ServiceGeneratorStrategy;
import org.cooder.jooq.mate.TableMeta;
import org.cooder.jooq.mate.TypeGenerator;
import org.jooq.tools.StringUtils;

public class TypeGeneratorStrategy
extends GeneratorStrategy {
    private String indent = "    ";
    private String packageName = "org.cooder.jooq";
    private String jooqPackageName;
    private Set<String> ignoreFieldNames = new HashSet<String>();
    private Set<String> includeTableNames = new HashSet<String>();
    private Set<String> excludeTableNames = new HashSet<String>();
    private Map<String, TableStrategy> tableStrategies = new HashMap<String, TableStrategy>();
    private RepoGeneratorStrategy repoStrategy = new RepoGeneratorStrategy();
    private ServiceGeneratorStrategy serviceStrategy = new ServiceGeneratorStrategy();
    private ApiGeneratorStrategy apiStrategy = new ApiGeneratorStrategy();
    private boolean generatePojoWithLombok = true;
    private boolean generateInterface = true;
    private boolean generateRecord = true;
    private boolean generatePojo = true;
    private boolean generateRepo = true;
    private NameConverter interfaceNameConverter;
    private NameConverter recordNameConverter;
    private NameConverter pojoNameConverter;
    private NameConverter repoNameConverter;
    private ConfigurationParser.Config conf;

    public TypeGeneratorStrategy withIndent(String indent) {
        this.indent = indent;
        return this;
    }

    public TypeGeneratorStrategy withConfig(ConfigurationParser.Config conf) {
        this.conf = conf;
        return this;
    }

    public GeneratorStrategy withIndent(int spaces) {
        this.withIndent(MateUtils.repeat(" ", spaces));
        return this;
    }

    public TypeGeneratorStrategy withDirectory(String directory) {
        this.setDirectory(directory);
        return this;
    }

    public TypeGeneratorStrategy withRepoDirectory(String directory) {
        this.repoStrategy.setDirectory(directory);
        return this;
    }

    public TypeGeneratorStrategy withServiceDirectory(String directory) {
        this.serviceStrategy.setDirectory(directory);
        return this;
    }

    public TypeGeneratorStrategy withApiDirectory(String directory) {
        this.apiStrategy.setDirectory(directory);
        return this;
    }

    public TypeGeneratorStrategy withPackageName(String packageName) {
        this.packageName = packageName;
        return this;
    }

    public TypeGeneratorStrategy withInterfaceNameConverter(NameConverter tableNameConverter) {
        this.interfaceNameConverter = tableNameConverter;
        return this;
    }

    public TypeGeneratorStrategy withRecordNameConverter(NameConverter recordNameConverter) {
        this.recordNameConverter = recordNameConverter;
        return this;
    }

    public TypeGeneratorStrategy withPojoNameConverter(NameConverter pojoNameConverter) {
        this.pojoNameConverter = pojoNameConverter;
        return this;
    }

    public TypeGeneratorStrategy withTableStrategy(String tableName, TableStrategy ts) {
        this.tableStrategies.put(tableName, ts);
        return this;
    }

    public TypeGeneratorStrategy ignoreFieldNames(String ... fields) {
        for (String f : fields) {
            this.ignoreFieldNames.add(f.trim());
        }
        return this;
    }

    public TypeGeneratorStrategy includeTableNames(String ... tables) {
        if (tables != null) {
            this.includeTableNames.addAll(Arrays.asList(tables));
        }
        return this;
    }

    public TypeGeneratorStrategy excludeTableNames(String ... tables) {
        this.excludeTableNames.addAll(Arrays.asList(tables));
        return this;
    }

    public boolean isIgnoreTable(String tableName) {
        return this.includeTableNames.isEmpty() ? this.excludeTableNames.contains(tableName) : !this.includeTableNames.contains(tableName);
    }

    public boolean isIgnoreField(String tableName, String fieldName) {
        TableStrategy ts = this.getTableStrategy(tableName);
        return this.ignoreFieldNames.contains(fieldName) || ts != null && ts.isIgnoreField(fieldName);
    }

    public boolean isGeneratePojoWithLombok(String tableName) {
        TableStrategy ts = this.getTableStrategy(tableName);
        return ts == null ? this.generatePojoWithLombok : ts.isGeneratePojoWithLombok(this.generatePojoWithLombok);
    }

    public boolean isGenerateInterface(String tableName) {
        TableStrategy ts = this.getTableStrategy(tableName);
        return ts == null ? this.generateInterface : ts.isGenerateInterface(this.generateInterface);
    }

    public boolean isGenerateRecord(String tableName) {
        TableStrategy ts = this.getTableStrategy(tableName);
        return ts == null ? this.generateRecord : ts.isGenerateRecord(this.generateRecord);
    }

    public boolean isGeneratePojo(String tableName) {
        TableStrategy ts = this.getTableStrategy(tableName);
        return ts == null ? this.generatePojo : ts.isGeneratePojo(this.generatePojo);
    }

    public List<TypeName> getGeneratedInterfaceSuperInterfaces(String tableName) {
        String[] ss = new String[]{};
        TableStrategy ts = this.getTableStrategy(tableName);
        if (ts != null) {
            ss = ts.getGeneratedInterfaceSuperInterfaces();
        }
        ClassName itc = this.interfaceClassName(tableName);
        ArrayList<TypeName> ret = new ArrayList<TypeName>();
        for (String s : ss) {
            ret.add(this.typeNameFrom(itc, s));
        }
        return ret;
    }

    public TypeName getPojoSuperClass(String tableName) {
        String sc = "";
        TableStrategy ts = this.getTableStrategy(tableName);
        if (ts != null) {
            sc = ts.getGeneratedPojoSuperClass();
        }
        ClassName pjc = this.pojoClassName(tableName);
        if (!StringUtils.isEmpty((String)sc)) {
            return this.typeNameFrom(pjc, sc);
        }
        return null;
    }

    public TableStrategy getTableStrategy(String tableName) {
        return this.tableStrategies.get(tableName);
    }

    public String convertInterfaceName(String tableName) {
        String name = null;
        if (this.interfaceNameConverter != null) {
            name = (String)this.interfaceNameConverter.apply(this, tableName);
        }
        return StringUtils.isEmpty(name) ? StringUtils.toCamelCase((String)tableName) : name;
    }

    public String convertRecordName(String tableName) {
        String name = null;
        if (this.recordNameConverter != null) {
            name = (String)this.recordNameConverter.apply(this, tableName);
        }
        return StringUtils.isEmpty(name) ? this.convertInterfaceName(tableName) + "Record" : name;
    }

    public String convertPojoName(String tableName) {
        String name = null;
        if (this.pojoNameConverter != null) {
            name = (String)this.pojoNameConverter.apply(this, tableName);
        }
        return StringUtils.isEmpty(name) ? this.convertInterfaceName(tableName) + "Entity" : name;
    }

    public String convertRepoName(String tableName) {
        String name = null;
        if (this.repoNameConverter != null) {
            name = (String)this.repoNameConverter.apply(this, tableName);
        }
        return StringUtils.isEmpty(name) ? this.convertInterfaceName(tableName) + "Repo" : name;
    }

    public String getTypePackageName() {
        return this.getPackageName() + ".type";
    }

    public String getRepoPakcgaeName() {
        return this.getPackageName() + ".repo";
    }

    public String getServicePackageName() {
        return this.getPackageName() + ".service";
    }

    public String getApiPackageName() {
        return this.getPackageName() + ".api";
    }

    public String subpackage(String tableName) {
        TableStrategy ts = this.getTableStrategy(tableName);
        return ts == null ? "" : ts.getSubPackageName();
    }

    public String interfacePackageName(String tableName) {
        return this.getTypePackageName() + this.subpackage(tableName);
    }

    public String pojoPackageName(String tableName) {
        return this.getTypePackageName() + ".pojos" + this.subpackage(tableName);
    }

    public String repoPackageName(String tableName) {
        return this.getRepoPakcgaeName() + this.subpackage(tableName);
    }

    public String servicePackageName(String tableName) {
        return this.getServicePackageName() + this.subpackage(tableName);
    }

    public String apiPackageName(String tableName) {
        return this.getApiPackageName() + this.subpackage(tableName);
    }

    public String recordPackageName(String tableName) {
        return this.getTypePackageName() + ".records" + this.subpackage(tableName);
    }

    public String jooqTablePackageName() {
        return this.getJooqPackageName() + ".tables";
    }

    public String jooqRecordPackageName() {
        return this.jooqTablePackageName() + ".records";
    }

    public String interfaceClazzName(String tableName) {
        return this.convertInterfaceName(tableName);
    }

    public String recordClazzName(String tableName) {
        return this.convertRecordName(tableName);
    }

    public String pojoClazzName(String tableName) {
        return this.convertPojoName(tableName);
    }

    public String repoClazzName(String tableName) {
        return this.convertRepoName(tableName);
    }

    public String serviceClazzName(String tableName) {
        return this.interfaceClazzName(tableName) + "Service";
    }

    public String controllerClazzName(String tableName) {
        return this.interfaceClazzName(tableName) + "Controller";
    }

    public ClassName interfaceClassName(String tableName) {
        return ClassName.get((String)this.interfacePackageName(tableName), (String)this.interfaceClazzName(tableName), (String[])new String[0]);
    }

    public ClassName recordClassName(String tableName) {
        return ClassName.get((String)this.recordPackageName(tableName), (String)this.recordClazzName(tableName), (String[])new String[0]);
    }

    public ClassName jooqRecordClassName(String tableName) {
        return ClassName.get((String)this.jooqRecordPackageName(), (String)this.recordClazzName(tableName), (String[])new String[0]);
    }

    public ClassName jooqTableClassName(String tableName) {
        return ClassName.get((String)this.jooqTablePackageName(), (String)this.interfaceClazzName(tableName), (String[])new String[0]);
    }

    public ClassName pojoClassName(String tableName) {
        return ClassName.get((String)this.pojoPackageName(tableName), (String)this.pojoClazzName(tableName), (String[])new String[0]);
    }

    public ClassName pojoAllClassName(String tableName) {
        return ClassName.get((String)this.pojoPackageName(tableName), (String)(this.pojoClazzName(tableName) + "All"), (String[])new String[0]);
    }

    public ClassName repoClassName(String tableName) {
        return ClassName.get((String)this.repoPackageName(tableName), (String)this.repoClazzName(tableName), (String[])new String[0]);
    }

    public ClassName serviceClassName(String tableName) {
        return ClassName.get((String)this.servicePackageName(tableName), (String)this.serviceClazzName(tableName), (String[])new String[0]);
    }

    public ClassName controllerClassName(String tableName) {
        return ClassName.get((String)this.apiPackageName(tableName), (String)this.controllerClazzName(tableName), (String[])new String[0]);
    }

    public String jooqTableVarName(String tableName) {
        return StringUtils.toLC((String)this.interfaceClazzName(tableName)) + "Table";
    }

    public boolean isGenerateRepo(String tableName) {
        return this.generateRepo;
    }

    public String getRepoDirectory() {
        return this.repoStrategy.getDirectory();
    }

    public String getServiceDirectory() {
        return this.serviceStrategy.getDirectory();
    }

    public String getApiDirectory() {
        return this.apiStrategy.getDirectory();
    }

    private TypeName typeNameFrom(ClassName itc, String name) {
        int idx = name.indexOf(60);
        if (idx >= 0) {
            ClassName base = ClassName.bestGuess((String)name.substring(0, idx));
            String gps = name.substring(idx + 1, name.lastIndexOf(62)).trim();
            if (StringUtils.isEmpty((String)gps)) {
                return ParameterizedTypeName.get((ClassName)base, (TypeName[])new TypeName[]{itc});
            }
            String[] parameters = gps.split(",");
            List<TypeName> typeNames = Arrays.asList(parameters).stream().map(p -> this.typeNameFrom(itc, (String)p)).collect(Collectors.toList());
            return ParameterizedTypeName.get((ClassName)base, (TypeName[])typeNames.toArray(new TypeName[0]));
        }
        return ClassName.bestGuess((String)name);
    }

    public List<TableMeta> subTables(String tableName) {
        ArrayList<TableMeta> metas = new ArrayList<TableMeta>();
        if (this.conf != null) {
            this.conf.tables().stream().filter(t -> tableName.equals(t.getParentTableName())).collect(Collectors.toList()).forEach(t -> metas.add(new TypeGenerator.TableConfigMeta((ConfigurationParser.TableConfig)t)));
        }
        return metas;
    }

    public boolean isRootTable(TableMeta table) {
        if (this.conf != null) {
            return this.conf.isRootTable(table.getName());
        }
        return true;
    }

    public String getIndent() {
        return this.indent;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getJooqPackageName() {
        return this.jooqPackageName;
    }

    public void setJooqPackageName(String jooqPackageName) {
        this.jooqPackageName = jooqPackageName;
    }

    public TypeGeneratorStrategy generatePojoWithLombok(boolean generatePojoWithLombok) {
        this.generatePojoWithLombok = generatePojoWithLombok;
        return this;
    }

    public TypeGeneratorStrategy generateInterface(boolean generateInterface) {
        this.generateInterface = generateInterface;
        return this;
    }

    public TypeGeneratorStrategy generateRecord(boolean generateRecord) {
        this.generateRecord = generateRecord;
        return this;
    }

    public TypeGeneratorStrategy generatePojo(boolean generatePojo) {
        this.generatePojo = generatePojo;
        return this;
    }

    public TypeGeneratorStrategy generateRepo(boolean generateRepo) {
        this.generateRepo = generateRepo;
        return this;
    }

    public static class TableStrategy {
        private String subPackageName = "";
        private Set<String> ignoreFieldNames = new HashSet<String>();
        private Boolean generatePojoWithLombok;
        private Boolean generateInterface;
        private Boolean generateRecord;
        private Boolean generatePojo;
        private String[] generatedInterfaceSuperInterfaces = new String[0];
        private String generatedPojoSuperClass = "";

        public TableStrategy ignoreFieldNames(String ... fields) {
            this.ignoreFieldNames.addAll(Arrays.asList(fields));
            return this;
        }

        public boolean isGeneratePojo(boolean def) {
            return this.generatePojo == null ? def : this.generatePojo;
        }

        public boolean isGenerateRecord(boolean def) {
            return this.generateRecord == null ? def : this.generateRecord;
        }

        public boolean isGenerateInterface(boolean def) {
            return this.generateInterface == null ? def : this.generateInterface;
        }

        public boolean isGeneratePojoWithLombok(boolean def) {
            return this.generatePojoWithLombok == null ? def : this.generatePojoWithLombok;
        }

        public boolean isIgnoreField(String fieldName) {
            return this.ignoreFieldNames.contains(fieldName);
        }

        public TableStrategy setSubPackageName(String subPackageName) {
            this.subPackageName = subPackageName;
            return this;
        }

        public TableStrategy setIgnoreFieldNames(Set<String> ignoreFieldNames) {
            this.ignoreFieldNames = ignoreFieldNames;
            return this;
        }

        public TableStrategy setGeneratePojoWithLombok(Boolean generatePojoWithLombok) {
            this.generatePojoWithLombok = generatePojoWithLombok;
            return this;
        }

        public TableStrategy setGenerateInterface(Boolean generateInterface) {
            this.generateInterface = generateInterface;
            return this;
        }

        public TableStrategy setGenerateRecord(Boolean generateRecord) {
            this.generateRecord = generateRecord;
            return this;
        }

        public TableStrategy setGeneratePojo(Boolean generatePojo) {
            this.generatePojo = generatePojo;
            return this;
        }

        public TableStrategy setGeneratedInterfaceSuperInterfaces(String[] generatedInterfaceSuperInterfaces) {
            this.generatedInterfaceSuperInterfaces = generatedInterfaceSuperInterfaces;
            return this;
        }

        public TableStrategy setGeneratedPojoSuperClass(String generatedPojoSuperClass) {
            this.generatedPojoSuperClass = generatedPojoSuperClass;
            return this;
        }

        public String getSubPackageName() {
            return this.subPackageName;
        }

        public String[] getGeneratedInterfaceSuperInterfaces() {
            return this.generatedInterfaceSuperInterfaces;
        }

        public String getGeneratedPojoSuperClass() {
            return this.generatedPojoSuperClass;
        }
    }

    @FunctionalInterface
    public static interface NameConverter
    extends BiFunction<TypeGeneratorStrategy, String, String> {
    }
}

