/*
 * Decompiled with CFR 0.152.
 */
package org.cooder.jooq.mate;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.element.Modifier;
import org.cooder.jooq.mate.FieldMeta;
import org.cooder.jooq.mate.Generator;
import org.cooder.jooq.mate.MateUtils;
import org.cooder.jooq.mate.TableMeta;
import org.cooder.jooq.mate.TypeGeneratorStrategy;
import org.jooq.tools.StringUtils;

class TypeInterfaceGenerator
implements Generator {
    private final TypeGeneratorStrategy strategy;

    public TypeInterfaceGenerator(TypeGeneratorStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public void generate(TableMeta table) {
        String tableName = table.getName();
        if (!this.strategy.isGenerateInterface(tableName)) {
            return;
        }
        String clazzName = this.strategy.interfaceClazzName(tableName);
        TypeSpec.Builder ts = TypeSpec.interfaceBuilder((String)clazzName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc(table.getComment(), new Object[0]);
        ts.addSuperinterfaces(this.strategy.getGeneratedInterfaceSuperInterfaces(tableName));
        FieldMeta[] fields = this.filterdFields(this.strategy, table);
        Arrays.asList(fields).forEach(f -> {
            this.generateGetter(ts, table, (FieldMeta)f);
            this.generateEnumGetter(ts, (FieldMeta)f);
            this.generateSetter(ts, table, (FieldMeta)f);
        });
        List<TableMeta> subTables = this.strategy.subTables(tableName);
        subTables.forEach(subTable -> this.generateSubListGetter(ts, (TableMeta)subTable));
        Arrays.asList(fields).forEach(f -> this.generateInnerEnums(ts, table, (FieldMeta)f));
        this.output(this.strategy.getIndent(), this.strategy.getDirectory(), this.strategy.interfacePackageName(tableName), ts.build());
    }

    private void generateGetter(TypeSpec.Builder ts, TableMeta table, FieldMeta f) {
        MethodSpec.Builder b = this.generateGetter(table, f);
        b.addModifiers(new Modifier[]{Modifier.ABSTRACT});
        ts.addMethod(b.build());
    }

    private void generateSetter(TypeSpec.Builder ts, TableMeta table, FieldMeta f) {
        MethodSpec.Builder b = this.generateSetter(table, f);
        b.addModifiers(new Modifier[]{Modifier.ABSTRACT});
        ts.addMethod(b.build());
    }

    private void generateSubListGetter(TypeSpec.Builder ts, TableMeta subTable) {
        String subTableName = subTable.getName();
        WildcardTypeName typeVariableName = WildcardTypeName.subtypeOf((TypeName)this.strategy.interfaceClassName(subTableName));
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)("get" + StringUtils.toCamelCase((String)subTableName) + "List")).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{typeVariableName})).addJavadoc("\u83b7\u53d6 `$L`\u5217\u8868", new Object[]{subTable.getNameDesc()}).addStatement("return null", new Object[0]);
        ts.addMethod(b.build());
    }

    private void generateEnumGetter(TypeSpec.Builder ts, FieldMeta f) {
        String enumString = f.getEnums();
        if (StringUtils.isEmpty((String)enumString)) {
            return;
        }
        String enumName = StringUtils.toCamelCase((String)f.getName());
        String methodName = String.format("get%sName", enumName);
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)methodName).addJavadoc("\u83b7\u53d6`" + f.getNameDesc() + "`\u540d\u79f0", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).returns(String.class);
        b.addStatement("return $L.from(get$L()).name", new Object[]{enumName, enumName});
        ts.addMethod(b.build());
    }

    private void generateInnerEnums(TypeSpec.Builder parent, TableMeta table, FieldMeta fm) {
        String[] pairs;
        String enumString = fm.getEnums();
        if (StringUtils.isEmpty((String)enumString) || !fm.isGenerateEnum()) {
            return;
        }
        String tableName = table.getName();
        String enumName = StringUtils.toCamelCase((String)fm.getName());
        ClassName enumClassName = this.getInnerEnumClassName(tableName, enumName);
        TypeSpec.Builder ts = TypeSpec.enumBuilder((String)enumName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        for (String pair : pairs = MateUtils.split(enumString, ",")) {
            String[] ss = MateUtils.split(pair, ":");
            ts.addEnumConstant(ss[1], TypeSpec.anonymousClassBuilder((String)"$L, $S", (Object[])new Object[]{ss[0], ss[1]}).build());
        }
        ts.addField(FieldSpec.builder(Integer.TYPE, (String)"value", (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).build());
        ts.addField(FieldSpec.builder(String.class, (String)"name", (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).build());
        ts.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter(Integer.TYPE, "value", new Modifier[0]).addParameter(String.class, "name", new Modifier[0]).addStatement("this.$L = $L", new Object[]{"value", "value"}).addStatement("this.$L = $L", new Object[]{"name", "name"}).build());
        ts.addMethod(MethodSpec.methodBuilder((String)"from").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)enumClassName).addParameter(Integer.TYPE, "value", new Modifier[0]).addCode(CodeBlock.builder().beginControlFlow("for ($T e : values())", new Object[]{enumClassName}).addStatement("if ( e.value == value) return e", new Object[0]).endControlFlow().addStatement("return null", new Object[0]).build()).build());
        parent.addType(ts.build());
    }

    private ClassName getInnerEnumClassName(String tableName, String name) {
        return ClassName.get((String)this.strategy.interfacePackageName(tableName), (String)this.strategy.interfaceClazzName(tableName), (String[])new String[]{name});
    }

    public static TypeInterfaceGenerator of(TypeGeneratorStrategy strategy) {
        return new TypeInterfaceGenerator(strategy);
    }
}

