/*
 * Decompiled with CFR 0.152.
 */
package org.cooder.jooq.mate;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.List;
import javax.lang.model.element.Modifier;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;
import lombok.experimental.SuperBuilder;
import org.cooder.jooq.mate.Generator;
import org.cooder.jooq.mate.TableMeta;
import org.cooder.jooq.mate.TypeGeneratorStrategy;
import org.jooq.tools.StringUtils;

class TypePojoAllGenerator
implements Generator {
    private final TypeGeneratorStrategy strategy;

    public TypePojoAllGenerator(TypeGeneratorStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public void generate(TableMeta table) {
        String tableName = table.getName();
        List<TableMeta> subTables = this.strategy.subTables(tableName);
        if (subTables.isEmpty()) {
            return;
        }
        ClassName pojoCN = this.strategy.pojoClassName(tableName);
        ClassName pojoAllCN = this.strategy.pojoAllClassName(tableName);
        TypeSpec.Builder ts = TypeSpec.classBuilder((String)pojoAllCN.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass((TypeName)pojoCN);
        subTables.forEach(subTable -> {
            String subTableName = subTable.getName();
            String fieldName = StringUtils.toCamelCaseLC((String)subTableName) + "List";
            FieldSpec spec = FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{this.strategy.pojoClassName(subTableName)}), (String)fieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE}).addJavadoc(subTable.getNameDesc() + "\u5217\u8868", new Object[0]).build();
            ts.addField(spec);
        });
        if (this.strategy.isGeneratePojoWithLombok(tableName)) {
            ts.addAnnotation(Data.class).addAnnotation(SuperBuilder.class).addAnnotation(NoArgsConstructor.class).addAnnotation(AnnotationSpec.builder(ToString.class).addMember("callSuper", "true", new Object[0]).build()).addAnnotation(AnnotationSpec.builder(EqualsAndHashCode.class).addMember("callSuper", "true", new Object[0]).build());
        } else {
            subTables.forEach(subTable -> {
                this.generateGetter(ts, table, (TableMeta)subTable);
                this.generateSetter(ts, table, (TableMeta)subTable);
            });
        }
        this.output(this.strategy.getIndent(), this.strategy.getDirectory(), this.strategy.pojoPackageName(tableName), ts.build());
    }

    private void generateGetter(TypeSpec.Builder ts, TableMeta table, TableMeta subTable) {
        String subTableName = subTable.getName();
        String fieldName = StringUtils.toCamelCase((String)subTableName) + "List";
        String nameLC = StringUtils.toCamelCaseLC((String)subTableName) + "List";
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)("get" + fieldName)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(this.subTableFieldType(this.strategy, subTableName)).addAnnotation(Override.class).addStatement("return this.$L", new Object[]{nameLC});
        ts.addMethod(b.build());
    }

    private void generateSetter(TypeSpec.Builder ts, TableMeta table, TableMeta subTable) {
        String subTableName = subTable.getName();
        String fieldName = StringUtils.toCamelCase((String)subTableName) + "List";
        String nameLC = StringUtils.toCamelCaseLC((String)subTableName) + "List";
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)("set" + fieldName)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Void.TYPE).addParameter(this.subTableFieldType(this.strategy, subTableName), nameLC, new Modifier[0]).addStatement("this.$L = $L", new Object[]{nameLC, nameLC});
        ts.addMethod(b.build());
    }

    public static TypePojoAllGenerator of(TypeGeneratorStrategy strategy) {
        return new TypePojoAllGenerator(strategy);
    }
}

