/*
 * Decompiled with CFR 0.152.
 */
package org.cooder.jooq.mate;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Arrays;
import javax.lang.model.element.Modifier;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;
import lombok.experimental.SuperBuilder;
import org.cooder.jooq.mate.FieldMeta;
import org.cooder.jooq.mate.Generator;
import org.cooder.jooq.mate.TableMeta;
import org.cooder.jooq.mate.TypeGeneratorStrategy;
import org.jooq.tools.StringUtils;

class TypePojoGenerator
implements Generator {
    private final TypeGeneratorStrategy strategy;

    public TypePojoGenerator(TypeGeneratorStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public void generate(TableMeta table) {
        String tableName = table.getName();
        if (!this.strategy.isGeneratePojo(tableName)) {
            return;
        }
        ClassName pojoCN = this.strategy.pojoClassName(tableName);
        TypeSpec.Builder ts = TypeSpec.classBuilder((String)pojoCN.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface((TypeName)this.strategy.interfaceClassName(tableName));
        TypeName superClass = this.strategy.getPojoSuperClass(tableName);
        if (superClass != null) {
            ts.superclass(superClass);
        }
        FieldMeta[] fields = this.filterdFields(this.strategy, table);
        this.generatePojoFields(ts, fields);
        if (this.strategy.isGeneratePojoWithLombok(tableName)) {
            ts.addAnnotation(Data.class).addAnnotation(SuperBuilder.class).addAnnotation(NoArgsConstructor.class).addAnnotation(AnnotationSpec.builder(ToString.class).addMember("callSuper", "true", new Object[0]).build());
            if (superClass != null) {
                ts.addAnnotation(AnnotationSpec.builder(EqualsAndHashCode.class).addMember("callSuper", "true", new Object[0]).build());
            } else {
                ts.addAnnotation(EqualsAndHashCode.class);
            }
        } else {
            Arrays.asList(fields).forEach(f -> {
                this.generateGetter(ts, table, (FieldMeta)f);
                this.generateSetter(ts, table, (FieldMeta)f);
            });
        }
        this.output(this.strategy.getIndent(), this.strategy.getDirectory(), this.strategy.pojoPackageName(tableName), ts.build());
    }

    private void generatePojoFields(TypeSpec.Builder ts, FieldMeta[] fields) {
        for (int i = 0; i < fields.length; ++i) {
            FieldMeta f = fields[i];
            String fieldName = StringUtils.toCamelCaseLC((String)f.getName());
            FieldSpec spec = FieldSpec.builder(f.getType(), (String)fieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE}).addJavadoc(f.getComment(), new Object[0]).build();
            ts.addField(spec);
        }
    }

    private void generateGetter(TypeSpec.Builder ts, TableMeta table, FieldMeta field) {
        String nameLC = StringUtils.toCamelCaseLC((String)field.getName());
        MethodSpec.Builder b = this.generateGetter(table, field);
        b.addAnnotation(Override.class);
        b.addStatement("return this.$N", new Object[]{nameLC});
        ts.addMethod(b.build());
    }

    private void generateSetter(TypeSpec.Builder ts, TableMeta table, FieldMeta f) {
        String nameLC = StringUtils.toCamelCaseLC((String)f.getName());
        MethodSpec.Builder b = this.generateSetter(table, f);
        b.addAnnotation(Override.class);
        b.addStatement("this.$N = $N", new Object[]{nameLC, nameLC});
        ts.addMethod(b.build());
    }

    public static TypePojoGenerator of(TypeGeneratorStrategy strategy) {
        return new TypePojoGenerator(strategy);
    }
}

