/*
 * Decompiled with CFR 0.152.
 */
package org.cooder.jooq.mate;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import org.cooder.jooq.mate.FieldMeta;
import org.cooder.jooq.mate.Generator;
import org.cooder.jooq.mate.TableMeta;
import org.cooder.jooq.mate.TypeGeneratorStrategy;
import org.cooder.jooq.mate.types.AbstractRecord;
import org.jooq.tools.StringUtils;

class TypeRecordGenerator
implements Generator {
    private final TypeGeneratorStrategy strategy;

    public TypeRecordGenerator(TypeGeneratorStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public void generate(TableMeta table) {
        String tableName = table.getName();
        if (!this.strategy.isGenerateRecord(tableName)) {
            return;
        }
        String clazz = this.strategy.recordClazzName(tableName);
        ClassName genericType = this.strategy.pojoClassName(tableName);
        TypeSpec.Builder ts = TypeSpec.classBuilder((String)clazz).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(AbstractRecord.class), (TypeName[])new TypeName[]{genericType})).addSuperinterface((TypeName)this.strategy.interfaceClassName(tableName));
        FieldMeta[] fields = this.filterdFields(this.strategy, table);
        this.generateRecordFields(ts, fields);
        this.generateRecordConstructor(ts, genericType);
        for (int i = 0; i < fields.length; ++i) {
            this.generateGetter(ts, table, fields[i], i);
            this.generateSetter(ts, table, fields[i], i);
        }
        this.output(this.strategy.getIndent(), this.strategy.getDirectory(), this.strategy.recordPackageName(tableName), ts.build());
    }

    private void generateRecordFields(TypeSpec.Builder ts, FieldMeta[] fields) {
        FieldSpec.Builder b = FieldSpec.builder(AbstractRecord.Field[].class, (String)"FIELDS", (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
        CodeBlock.Builder cb = CodeBlock.builder();
        cb.add("new Field[] {\n", new Object[0]);
        for (int i = 0; i < fields.length; ++i) {
            String fieldName = StringUtils.toCamelCaseLC((String)fields[i].getName());
            cb.add(this.strategy.getIndent() + "$T.builder().name($S).type($T.class).desc($S).uniqKey($L).dbName($S).build(),\n", new Object[]{AbstractRecord.Field.class, fieldName, fields[i].getType(), fields[i].getNameDesc(), fields[i].isUniqKey(), fields[i].getName()});
        }
        cb.add("}", new Object[0]);
        b.initializer(cb.build());
        ts.addField(b.build());
    }

    private void generateRecordConstructor(TypeSpec.Builder ts, ClassName genericType) {
        MethodSpec.Builder b = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        b.addStatement("super($T.class, FIELDS)", new Object[]{genericType});
        ts.addMethod(b.build());
    }

    private void generateGetter(TypeSpec.Builder ts, TableMeta table, FieldMeta field, int index) {
        MethodSpec.Builder b = this.generateGetter(table, field);
        b.addAnnotation(Override.class);
        b.addStatement("return ($T)get($L)", new Object[]{field.getType(), index});
        ts.addMethod(b.build());
    }

    private void generateSetter(TypeSpec.Builder ts, TableMeta table, FieldMeta f, int index) {
        String nameLC = StringUtils.toCamelCaseLC((String)f.getName());
        MethodSpec.Builder b = this.generateSetter(table, f);
        b.addAnnotation(Override.class);
        b.addStatement("set($L, $N)", new Object[]{index, nameLC});
        ts.addMethod(b.build());
    }

    public static TypeRecordGenerator of(TypeGeneratorStrategy strategy) {
        return new TypeRecordGenerator(strategy);
    }
}

