/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.accounts.organization.impl;

import java.io.Serializable;
import javax.inject.Inject;
import org.coodex.concrete.accounts.organization.api.AbstractDepartmentManagementService;
import org.coodex.concrete.accounts.organization.entities.AbstractDepartmentEntity;
import org.coodex.concrete.accounts.organization.entities.AbstractPersonAccountEntity;
import org.coodex.concrete.accounts.organization.entities.AbstractPositionEntity;
import org.coodex.concrete.accounts.organization.entities.OrganizationEntity;
import org.coodex.concrete.accounts.organization.impl.AbstractManagementService;
import org.coodex.concrete.accounts.organization.pojo.Department;
import org.coodex.concrete.accounts.organization.repositories.AbstractDepartmentRepo;
import org.coodex.concrete.api.pojo.StrID;
import org.coodex.concrete.common.Assert;
import org.coodex.concrete.common.ConcreteContext;
import org.coodex.concrete.common.TwoWayCopier;
import org.coodex.util.Common;

public abstract class AbstractDepartmentManagementServiceImpl<D extends Department, E extends AbstractDepartmentEntity, J extends AbstractPositionEntity, P extends AbstractPersonAccountEntity<J>>
extends AbstractManagementService<J, P>
implements AbstractDepartmentManagementService<D> {
    @Inject
    protected AbstractDepartmentRepo<E> departmentRepo;
    @Inject
    protected TwoWayCopier<D, E> departmentCopier;

    protected E getDepartmentEntity(String id) {
        Assert.isNull((Object)id, (int)11002, (Object[])new Object[0]);
        return (E)((AbstractDepartmentEntity)Assert.isNull((Object)this.departmentRepo.findOne((Serializable)((Object)id)), (int)11002, (Object[])new Object[0]));
    }

    public StrID<D> save(D department, String higherLevel) {
        this.checkManagementPermission(higherLevel);
        this.checkDuplication(higherLevel, department.getName(), null);
        AbstractDepartmentEntity departmentEntity = (AbstractDepartmentEntity)this.departmentCopier.copyA2B(department);
        departmentEntity.setHigherLevel(this.checkBelongToExists(higherLevel));
        ConcreteContext.putLoggingData((String)"new", (Object)departmentEntity);
        return new StrID(departmentEntity.getId(), this.departmentCopier.copyB2A(this.departmentRepo.save((Object)departmentEntity), department));
    }

    public void update(String id, D department) {
        this.checkManagementPermission(id);
        E departmentEntity = this.getDepartmentEntity(id);
        this.checkDuplication(departmentEntity.getHigherLevelId(), department.getName(), id);
        ConcreteContext.putLoggingData((String)"old", this.deepCopy(departmentEntity));
        ConcreteContext.putLoggingData((String)"new", (Object)this.departmentRepo.save(this.departmentCopier.copyA2B(department, departmentEntity)));
    }

    public void updateHigherLevel(String id, String higherLevel) {
        this.checkManagementPermission(id);
        this.checkManagementPermission(higherLevel);
        OrganizationEntity higherLevelEntity = this.checkBelongToExists(higherLevel);
        E departmentEntity = this.getDepartmentEntity(id);
        this.checkManagementPermission(departmentEntity.getHigherLevelId());
        if (!Common.sameString((String)higherLevel, (String)departmentEntity.getHigherLevelId())) {
            ConcreteContext.putLoggingData((String)"original", (Object)departmentEntity.getHigherLevel());
            departmentEntity.setHigherLevel(higherLevelEntity);
            this.departmentRepo.save(departmentEntity);
            ConcreteContext.putLoggingData((String)"target", (Object)departmentEntity.getHigherLevel());
        }
    }

    public void updateOrder(String id, Integer order) {
        this.checkManagementPermission(id);
        this.updateOrder(order, this.getDepartmentEntity(id), this.departmentRepo);
    }

    public void delete(String id) {
        this.checkManagementPermission(id);
        ConcreteContext.putLoggingData((String)"deleted", this.deleteOrganization((OrganizationEntity)this.getDepartmentEntity(id)));
    }
}

