/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.accounts.organization.impl;

import java.io.Serializable;
import java.util.Calendar;
import javax.inject.Inject;
import org.coodex.concrete.accounts.AbstractAdministratorFactory;
import org.coodex.concrete.accounts.AccountIDImpl;
import org.coodex.concrete.accounts.AccountsCommon;
import org.coodex.concrete.accounts.CanLoginEntity;
import org.coodex.concrete.accounts.TenantRPCServiceClient;
import org.coodex.concrete.accounts.organization.api.AbstractLoginService;
import org.coodex.concrete.accounts.organization.entities.AbstractPersonAccountEntity;
import org.coodex.concrete.accounts.organization.entities.AbstractPositionEntity;
import org.coodex.concrete.accounts.organization.entities.LoginCacheEntryEntity;
import org.coodex.concrete.accounts.organization.impl.AbstractOrganizationAccountFactory;
import org.coodex.concrete.accounts.organization.repositories.AbstractPersonAccountRepo;
import org.coodex.concrete.accounts.organization.repositories.LoginCacheEntryRepo;
import org.coodex.concrete.common.Assert;
import org.coodex.concrete.common.ConcreteContext;
import org.coodex.concrete.common.ConcreteException;
import org.coodex.concrete.common.Token;
import org.coodex.concrete.core.token.TokenWrapper;
import org.coodex.util.Common;

public abstract class AbstractLoginServiceImpl<JE extends AbstractPositionEntity, PE extends AbstractPersonAccountEntity<JE>>
implements AbstractLoginService {
    @Inject
    protected AbstractPersonAccountRepo<PE> personAccountRepo;
    @Inject
    protected LoginCacheEntryRepo loginCacheEntryRepo;
    protected Token token = TokenWrapper.getInstance();
    @Inject
    protected AbstractOrganizationAccountFactory abstractOrganizationAccountFactory;
    @Inject
    protected AbstractAdministratorFactory administratorFactory;
    @Inject
    protected TenantRPCServiceClient tenantRPCServiceClient;

    public String login(String tenant, String account, String password, String authCode) {
        if (Common.isBlank((String)account)) {
            this.administratorLogin(tenant, password, authCode);
            return null;
        }
        AbstractPersonAccountEntity personEntity = (AbstractPersonAccountEntity)Assert.isNull(this.getPersonEntity(account, tenant), (int)10001, (Object[])new Object[0]);
        AccountsCommon.checkPassword((String)password, (CanLoginEntity)personEntity);
        this.tenantRPCServiceClient.checkTenant(personEntity.getTenant());
        this.token.setAccountCredible(AccountsCommon.isCredible((String)authCode, (CanLoginEntity)personEntity));
        this.token.setAccount(this.abstractOrganizationAccountFactory.getAccountByID(new AccountIDImpl(1, personEntity.getId())));
        ConcreteContext.putLoggingData((String)"loginUser", (Object)personEntity);
        return this.updateLoginCacheEntry(personEntity);
    }

    protected String updateLoginCacheEntry(PE personEntity) {
        try {
            LoginCacheEntryEntity loginCacheEntryEntity = (LoginCacheEntryEntity)this.loginCacheEntryRepo.findOne((Serializable)((Object)personEntity.getId()));
            if (loginCacheEntryEntity == null) {
                loginCacheEntryEntity = new LoginCacheEntryEntity();
                loginCacheEntryEntity.setAccountId(personEntity.getId());
                loginCacheEntryEntity.setCredential(this.newCredential());
                loginCacheEntryEntity.setValidation(this.getValidationFromNow());
            }
            loginCacheEntryEntity.setLastLogin(Calendar.getInstance());
            this.setValidation(loginCacheEntryEntity);
            return ((LoginCacheEntryEntity)this.loginCacheEntryRepo.save((Object)loginCacheEntryEntity)).getCredential();
        }
        catch (RuntimeException e) {
            this.token.setAccount(null);
            this.token.setAccountCredible(false);
            throw e;
        }
    }

    protected void setValidation(LoginCacheEntryEntity loginCacheEntryEntity) {
        if (AccountsCommon.SETTINGS.getBool("validation.defer", false)) {
            loginCacheEntryEntity.setValidation(this.getValidationFromNow());
        }
    }

    protected String newCredential() {
        return Common.getUUIDStr();
    }

    protected Calendar getValidationFromNow() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, AccountsCommon.SETTINGS.getInt("validation.days", 7));
        return calendar;
    }

    protected PE getPersonEntity(String account, String tenant) {
        if (this.isCellPhone(account)) {
            return (PE)this.personAccountRepo.findFirstByCellphoneAndTenant(account, tenant);
        }
        if (this.isIdCard(account)) {
            return (PE)this.personAccountRepo.findFirstByIdCardNoAndTenant(account, tenant);
        }
        if (this.isEmail(account)) {
            return (PE)this.personAccountRepo.findFirstByEmailAndTenant(account, tenant);
        }
        return this.getAccountEntityBy(account, tenant);
    }

    protected PE getAccountEntityBy(String account, String tenant) {
        return null;
    }

    protected PE getAccountEntityByCellPhone(String cellPhone, String tenant) {
        return (PE)this.personAccountRepo.findFirstByCellphoneAndTenant(cellPhone, tenant);
    }

    protected PE getAccountEntityByEmail(String email, String tenant) {
        return (PE)this.personAccountRepo.findFirstByEmailAndTenant(email, tenant);
    }

    protected PE getAccountEntityByIdCardNo(String idCardNo, String tenant) {
        return (PE)this.personAccountRepo.findFirstByIdCardNoAndTenant(idCardNo, tenant);
    }

    protected boolean hasAtChar(String account) {
        return account.indexOf(64) > 0;
    }

    protected boolean isCellPhone(String account) {
        return account.length() == 11 && !this.hasAtChar(account);
    }

    protected boolean isIdCard(String account) {
        return (account.length() == 15 || account.length() == 18) && !this.hasAtChar(account);
    }

    protected boolean isEmail(String account) {
        return this.hasAtChar(account);
    }

    public void administratorLogin(String tenant, String password, String authCode) {
        this.administratorFactory.login(tenant, AccountsCommon.SETTINGS.getString("administrator.id"), password, authCode);
    }

    public void loginWith(String credential) {
        LoginCacheEntryEntity loginCacheEntryEntity = (LoginCacheEntryEntity)Assert.isNull((Object)this.loginCacheEntryRepo.findFirstByCredential(credential), (int)10003, (Object[])new Object[0]);
        AbstractPersonAccountEntity personEntity = (AbstractPersonAccountEntity)Assert.isNull((Object)this.personAccountRepo.findOne((Serializable)((Object)loginCacheEntryEntity.getAccountId())), (int)10001, (Object[])new Object[0]);
        this.tenantRPCServiceClient.checkTenant(personEntity.getTenant());
        this.token.setAccount(this.abstractOrganizationAccountFactory.getAccountByID(new AccountIDImpl(1, personEntity.getId())));
        this.token.setAccountCredible(false);
        ConcreteContext.putLoggingData((String)"loginUser", (Object)personEntity);
    }

    public String identification(String authCode) {
        AbstractPersonAccountEntity personEntity = (AbstractPersonAccountEntity)Assert.isNull((Object)this.personAccountRepo.findOne((Serializable)((Object)((AccountIDImpl)this.token.currentAccount().getId()).getId())), (int)10001, (Object[])new Object[0]);
        String credential = null;
        if (!AccountsCommon.isCredible((String)authCode, (CanLoginEntity)personEntity)) {
            throw new ConcreteException(10002, new Object[0]);
        }
        credential = this.updateLoginCacheEntry(personEntity);
        this.token.setAccountCredible(true);
        return credential;
    }

    public void logout() {
        this.token.invalidate();
    }
}

