/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.accounts.organization.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.coodex.commons.jpa.springdata.SpecCommon;
import org.coodex.concrete.accounts.AccountsCommon;
import org.coodex.concrete.accounts.AuthorizableEntity;
import org.coodex.concrete.accounts.organization.entities.AbstractEntity;
import org.coodex.concrete.accounts.organization.entities.AbstractPersonAccountEntity;
import org.coodex.concrete.accounts.organization.entities.AbstractPositionEntity;
import org.coodex.concrete.accounts.organization.entities.OrganizationEntity;
import org.coodex.concrete.accounts.organization.impl.AbstractOrgService;
import org.coodex.concrete.accounts.organization.repositories.AbstractPositionRepo;
import org.coodex.concrete.common.Assert;
import org.coodex.concrete.common.ConcreteContext;
import org.coodex.concrete.common.ConcreteException;
import org.coodex.util.Common;
import org.springframework.data.repository.CrudRepository;

@Transactional(rollbackOn={Throwable.class})
public abstract class AbstractManagementService<J extends AbstractPositionEntity, P extends AbstractPersonAccountEntity<J>>
extends AbstractOrgService<J, P> {
    @Inject
    protected AbstractPositionRepo<J> positionRepo;

    protected <O extends Serializable> O deepCopy(O value) {
        try {
            return (O)Common.deepCopy(value);
        }
        catch (Throwable th) {
            throw new ConcreteException(99999, new Object[]{th.getLocalizedMessage(), th});
        }
    }

    protected <O extends AbstractEntity, R extends CrudRepository<O, String>> void updateOrder(Integer order, O entity, R repo) {
        if (order == null) {
            order = AbstractEntity.DEFAULT_ORDER;
        }
        if (entity.getDisplayOrder().intValue() != order.intValue()) {
            ConcreteContext.putLoggingData((String)"object", entity);
            ConcreteContext.putLoggingData((String)"original", (Object)entity.getDisplayOrder());
            entity.setDisplayOrder(order);
            repo.save(entity);
            ConcreteContext.putLoggingData((String)"target", (Object)order);
        }
    }

    protected J deletePosition(J positionEntity) {
        Assert.is((this.personAccountRepo.count(SpecCommon.memberOf((String)"positions", positionEntity)) > 0L ? 1 : 0) != 0, (int)11006, (Object[])new Object[0]);
        this.positionRepo.delete(positionEntity);
        return positionEntity;
    }

    protected Collection<AbstractEntity> deleteOrganization(OrganizationEntity entity) {
        ArrayList<AbstractEntity> deletedEntities = new ArrayList<AbstractEntity>();
        for (AbstractPositionEntity position : this.positionRepo.findByBelong(entity.getId())) {
            deletedEntities.add((AbstractEntity)this.deletePosition(position));
        }
        for (OrganizationEntity organizationEntity : this.organizationRepo.findByTenantAndHigherLevelId(AccountsCommon.getTenant(), entity.getId())) {
            deletedEntities.addAll(this.deleteOrganization(organizationEntity));
        }
        this.organizationRepo.delete((Object)entity);
        deletedEntities.add((AbstractEntity)entity);
        return deletedEntities;
    }

    protected <E extends AuthorizableEntity, R extends CrudRepository<E, String>> void grantTo(E entity, R repo, String[] roles) {
        HashSet<String> target;
        Set original = Common.join((Collection[])new Collection[]{entity.getRoles()});
        HashSet<String> hashSet = target = roles == null || roles.length == 0 ? new HashSet<String>() : new HashSet<String>(Arrays.asList(roles));
        if (Common.difference(target, (Set)original).size() > 0 || Common.difference((Set)original, target).size() > 0) {
            entity.setRoles(target);
            ConcreteContext.putLoggingData((String)"object", (Object)repo.save(entity));
            ConcreteContext.putLoggingData((String)"original", (Object)original);
            ConcreteContext.putLoggingData((String)"target", target);
        }
    }
}

